/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.jarslink.api.impl;

import com.alipay.jarslink.api.Module;
import com.alipay.jarslink.api.ModuleConfig;
import com.alipay.jarslink.api.ModuleLoader;
import com.alipay.jarslink.api.ModuleManager;
import com.alipay.jarslink.api.impl.ModuleUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractModuleRefreshScheduler
implements InitializingBean,
DisposableBean,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractModuleRefreshScheduler.class);
    private static final int DEFAULT_INITIAL_DELAY = 5;
    private static final int DEFAULT_REFRESH_DELAY = 60;
    private int initialDelay = 5;
    private int refreshDelay = 60;
    private ScheduledExecutorService scheduledExecutor;
    private ModuleManager moduleManager;
    private ModuleLoader moduleLoader;

    public void afterPropertiesSet() throws Exception {
        this.refreshModuleConfigs();
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("module_refresh-schedule-pool-%d").daemon(true).build());
        this.scheduledExecutor.scheduleWithFixedDelay(this, this.initialDelay, this.refreshDelay, TimeUnit.SECONDS);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("AbstractModuleRefreshScheduler start");
        }
    }

    public void destroy() throws Exception {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
    }

    @Override
    public void run() {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Start module configs refresh");
            }
            this.refreshModuleConfigs();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Stop module configs refresh");
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to refresh module configs", e);
        }
    }

    public abstract List<ModuleConfig> queryModuleConfigs();

    private void refreshModuleConfigs() {
        Map<String, ModuleConfig> moduleConfigs = this.indexModuleConfigByModuleName(this.filterEnabledModule());
        Map<String, String> configVersions = this.transformToConfigVersions(moduleConfigs);
        Map<String, String> moduleVersions = this.transformToModuleVersions(this.moduleManager.getModules());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Config size: {}", (Object)configVersions.size());
            LOGGER.info("Module size: {}", (Object)moduleVersions.size());
            LOGGER.info("now in map {}", moduleVersions);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Config versions: {}", configVersions);
            LOGGER.debug("Module versions: {}", moduleVersions);
        }
        MapDifference difference = Maps.difference(configVersions, moduleVersions);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Version difference: {}", (Object)difference);
        }
        this.putModules(moduleConfigs, this.configAdds((MapDifference<String, String>)difference));
        this.putModules(moduleConfigs, this.configDifference((MapDifference<String, String>)difference));
        this.removeModules(this.modulesRedundant((MapDifference<String, String>)difference));
    }

    private Collection<ModuleConfig> filterEnabledModule() {
        List<ModuleConfig> moduleConfigs = this.queryModuleConfigs();
        if (moduleConfigs == null || moduleConfigs.isEmpty()) {
            return new ArrayList<ModuleConfig>();
        }
        return Collections2.filter(moduleConfigs, (Predicate)new Predicate<ModuleConfig>(){

            public boolean apply(ModuleConfig moduleConfig) {
                return moduleConfig.getEnabled();
            }
        });
    }

    private void putModules(Map<String, ModuleConfig> moduleConfigs, Set<String> moduleNames) {
        for (String name : moduleNames) {
            ModuleConfig moduleConfig = moduleConfigs.get(name);
            try {
                if (this.isFailedVersion(moduleConfig)) {
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("this version is failed, ignore.{}", (Object)moduleConfig);
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Load module config: {}", (Object)moduleConfig);
                }
                Module module = this.moduleLoader.load(moduleConfig);
                Module removed = this.moduleManager.register(module);
                ModuleUtil.destroyQuietly(removed);
                this.moduleManager.getErrorModuleContext().remove(name.toUpperCase(Locale.CHINESE));
                this.moduleManager.getErrorModuleContext().remove(name.toUpperCase(Locale.CHINESE) + "_ERROR");
            }
            catch (Exception e) {
                this.moduleManager.getErrorModuleContext().put(name.toUpperCase(Locale.CHINESE) + "_ERROR", ToStringBuilder.reflectionToString((Object)e));
                this.moduleManager.getErrorModuleContext().put(name.toUpperCase(Locale.CHINESE), moduleConfig.getVersion());
                LOGGER.error("Failed to load module config: " + moduleConfig, (Throwable)e);
            }
            catch (Error e) {
                LOGGER.error("Failed to load module config: " + moduleConfig, (Throwable)e);
            }
        }
    }

    private boolean isFailedVersion(ModuleConfig moduleConfig) {
        Preconditions.checkNotNull((Object)moduleConfig, (Object)"moduleConfig is null");
        String name = moduleConfig.getName();
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        String version = this.moduleManager.getErrorModuleContext().get(name.toUpperCase(Locale.CHINESE));
        return moduleConfig.getVersion().equals(version);
    }

    private void removeModules(Set<String> modulesRedundant) {
        for (String moduleName : modulesRedundant) {
            Module removed = this.moduleManager.remove(moduleName);
            ModuleUtil.destroyQuietly(removed);
        }
    }

    private Set<String> modulesRedundant(MapDifference<String, String> difference) {
        return difference.entriesOnlyOnRight().keySet();
    }

    private Set<String> configDifference(MapDifference<String, String> difference) {
        return difference.entriesDiffering().keySet();
    }

    private Set<String> configAdds(MapDifference<String, String> difference) {
        return difference.entriesOnlyOnLeft().keySet();
    }

    private Map<String, String> transformToModuleVersions(List<Module> modules) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)Maps.uniqueIndex(modules, (Function)new Function<Module, String>(){

            public String apply(Module input) {
                return input.getName();
            }
        }), (Function)new Function<Module, String>(){

            public String apply(Module input) {
                return input.getVersion();
            }
        }));
    }

    private Map<String, String> transformToConfigVersions(Map<String, ModuleConfig> moduleConfigs) {
        return ImmutableMap.copyOf((Map)Maps.transformValues(moduleConfigs, (Function)new Function<ModuleConfig, String>(){

            public String apply(ModuleConfig input) {
                return input.getVersion();
            }
        }));
    }

    private Map<String, ModuleConfig> indexModuleConfigByModuleName(Collection<ModuleConfig> list) {
        return ImmutableMap.copyOf((Map)Maps.uniqueIndex(list, (Function)new Function<ModuleConfig, String>(){

            public String apply(ModuleConfig input) {
                return input.getName();
            }
        }));
    }

    @Required
    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    @Required
    public void setModuleLoader(ModuleLoader moduleLoader) {
        this.moduleLoader = moduleLoader;
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public void setRefreshDelay(int refreshDelay) {
        this.refreshDelay = refreshDelay;
    }
}

