/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.jarslink.api.impl;

import com.alipay.jarslink.api.Module;
import com.alipay.jarslink.api.ModuleConfig;
import com.alipay.jarslink.api.ModuleLoader;
import com.alipay.jarslink.api.impl.ModuleAnnotationApplicationContext;
import com.alipay.jarslink.api.impl.ModuleClassLoader;
import com.alipay.jarslink.api.impl.ModuleXmlApplicationContext;
import com.alipay.jarslink.api.impl.SpringModule;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ModuleLoaderImpl
implements ModuleLoader,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleLoaderImpl.class);
    private static String[] SPRING_XML_PATTERN = new String[]{"classpath*:META-INF/spring/*.xml", "classpath*:*META-INF/spring/*.xml"};
    private static final String MODULE_PROPERTY_VERSION = "module_version";
    private static final String MODULE_PROPERTY_NAME = "module_name";
    private static final String MODULE_EXCLUSION_CONFIGE_NAME = "exclusion_confige_name";
    private ApplicationContext applicationContext;

    @Override
    public Module load(ModuleConfig moduleConfig) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Loading module: {}", (Object)moduleConfig);
        }
        List<String> tempFileJarURLs = moduleConfig.getModuleUrlPath();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Local jars: {}", tempFileJarURLs);
        }
        ConfigurableApplicationContext moduleApplicationContext = this.loadModuleApplication(moduleConfig, tempFileJarURLs);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Loading module  complete\uff1a{}", (Object)moduleConfig);
        }
        return new SpringModule(moduleConfig, moduleConfig.getVersion(), moduleConfig.getName(), moduleApplicationContext);
    }

    @Override
    public void unload(Module module) {
        if (module != null) {
            module.destroy();
        }
    }

    private ConfigurableApplicationContext loadModuleApplication(ModuleConfig moduleConfig, List<String> tempFileJarURLs) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ModuleClassLoader moduleClassLoader = new ModuleClassLoader(moduleConfig.getModuleUrl(), this.applicationContext.getClassLoader(), this.getOverridePackages(moduleConfig));
        try {
            Object context;
            Thread.currentThread().setContextClassLoader(moduleClassLoader);
            Properties properties = this.getProperties(moduleConfig);
            Set<String> scanBase = moduleConfig.getScanPackages();
            if (!scanBase.isEmpty()) {
                ModuleAnnotationApplicationContext annotationConfigApplicationContext = new ModuleAnnotationApplicationContext(properties);
                annotationConfigApplicationContext.scan(scanBase.toArray(new String[0]));
                context = annotationConfigApplicationContext;
            } else {
                ModuleXmlApplicationContext moduleApplicationContext = new ModuleXmlApplicationContext();
                moduleApplicationContext.setProperties(properties);
                moduleApplicationContext.setConfigLocations(this.findSpringConfigs(tempFileJarURLs, moduleClassLoader, this.getExclusionConfigeNameList(properties)));
                context = moduleApplicationContext;
            }
            context.setParent(this.applicationContext);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("module {}:{} allow current process to override bean in module", (Object)moduleConfig.getName(), (Object)moduleConfig.getVersion());
            }
            ((DefaultResourceLoader)context).setClassLoader((ClassLoader)moduleClassLoader);
            context.refresh();
            Object object = context;
            return object;
        }
        catch (Throwable e) {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)moduleClassLoader);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private List<String> getExclusionConfigeNameList(Properties properties) {
        String property = properties.getProperty(MODULE_EXCLUSION_CONFIGE_NAME);
        if (property != null) {
            return Lists.newArrayList((Object[])property.split(","));
        }
        return Lists.newArrayList();
    }

    private Properties getProperties(ModuleConfig moduleConfig) {
        Properties properties = ModuleLoaderImpl.toProperties(moduleConfig.getProperties());
        properties.setProperty(MODULE_PROPERTY_NAME, moduleConfig.getName());
        properties.setProperty(MODULE_PROPERTY_VERSION, moduleConfig.getVersion());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Module Properties: {}", (Object)properties);
        }
        return properties;
    }

    private String[] findSpringConfigs(List<String> tempFileJarURLs, ClassLoader moduleClassLoader, List<String> exclusionConfigeNameList) {
        try {
            PathMatchingResourcePatternResolver pmr = new PathMatchingResourcePatternResolver(moduleClassLoader);
            Resource[] resources = (Resource[])ImmutableSet.builder().add((Object[])pmr.getResources(SPRING_XML_PATTERN[0])).add((Object[])pmr.getResources(SPRING_XML_PATTERN[1])).build().toArray((Object[])new Resource[0]);
            Preconditions.checkNotNull((Object)resources, (Object)"resources is null");
            Preconditions.checkArgument((resources.length > 0 ? 1 : 0) != 0, (Object)"resources length is 0");
            return this.filterURLsIncludedResources(tempFileJarURLs, resources, exclusionConfigeNameList);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to find spring configs from " + tempFileJarURLs, e);
        }
    }

    private String[] filterURLsIncludedResources(List<String> tempFileJarURLs, Resource[] resources, List<String> exclusionConfigeNameList) throws IOException {
        ArrayList configLocations = Lists.newArrayList();
        for (Resource resource : resources) {
            String configLocation = resource.getURL().toString();
            for (String url : tempFileJarURLs) {
                if (this.isExclusionConfig(configLocation, exclusionConfigeNameList)) {
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("exclusion url: {}", (Object)configLocation);
                    continue;
                }
                if (!configLocation.contains(url)) continue;
                configLocations.add(configLocation);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Config locations: {}", (Object)configLocations);
        }
        return (String[])Iterables.toArray((Iterable)configLocations, String.class);
    }

    private boolean isExclusionConfig(String url, List<String> exclusionConfigeNameList) {
        for (String tmp : exclusionConfigeNameList) {
            if (!url.contains(tmp)) continue;
            return true;
        }
        return false;
    }

    private List<String> getOverridePackages(ModuleConfig moduleConfig) {
        ArrayList list = Lists.newArrayList();
        for (String s : moduleConfig.getOverridePackages()) {
            if (StringUtils.isBlank((String)s)) continue;
            list.add(s);
        }
        return list;
    }

    private static Properties toProperties(Map<String, Object> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> each : map.entrySet()) {
            if (each.getKey() == null || each.getValue() == null) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Ignore null properties: {}={}", (Object)each.getKey(), each.getValue());
                continue;
            }
            if (StringUtils.isBlank((String)each.getKey())) continue;
            properties.setProperty(each.getKey(), each.getValue().toString());
        }
        return properties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

