/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.jarslink.api.impl;

import com.alipay.jarslink.api.Module;
import com.alipay.jarslink.api.ModuleManager;
import com.alipay.jarslink.api.impl.RuntimeModule;
import com.alipay.jarslink.api.impl.SpringModule;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class ModuleManagerImpl
implements ModuleManager,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleManagerImpl.class);
    private final ConcurrentHashMap<String, RuntimeModule> allModules = new ConcurrentHashMap();

    private RuntimeModule getRuntimeModule(String name) {
        RuntimeModule runtimeModule = this.allModules.get(name.toUpperCase());
        return runtimeModule != null ? runtimeModule : new RuntimeModule();
    }

    @Override
    public List<Module> getModules() {
        ArrayList modules = Lists.newArrayList();
        for (String name : this.allModules.keySet()) {
            RuntimeModule runtimeModule = this.getRuntimeModule(name);
            for (String version : runtimeModule.getModules().keySet()) {
                modules.add(runtimeModule.getModules().get(version));
            }
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)modules, (Predicate)Predicates.instanceOf(SpringModule.class)));
    }

    @Override
    public Module find(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"module name is null");
        String defaultVersion = this.getDefaultVersion(name);
        Preconditions.checkNotNull((Object)defaultVersion, (Object)"module default version is null");
        return this.find(name, defaultVersion);
    }

    private String getDefaultVersion(String name) {
        return this.getRuntimeModule(name).getDefaultVersion();
    }

    @Override
    public Module find(String name, String version) {
        Preconditions.checkNotNull((Object)name, (Object)"module name is null");
        Preconditions.checkNotNull((Object)version, (Object)"module version is null");
        return this.getRuntimeModule(name).getModule(version);
    }

    @Override
    public void activeVersion(String name, String version) {
        Preconditions.checkNotNull((Object)name, (Object)"module name is null");
        Preconditions.checkNotNull((Object)version, (Object)"module version is null");
        this.getRuntimeModule(name).setDefaultVersion(version);
    }

    @Override
    public String getActiveVersion(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"module name is null");
        return this.getDefaultVersion(name);
    }

    @Override
    public Module register(Module module) {
        Module registeredModule;
        Preconditions.checkNotNull((Object)module, (Object)"module is null");
        String name = module.getName();
        String version = module.getVersion();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("register Module: {}-{}", (Object)name, (Object)version);
        }
        if ((registeredModule = this.getRuntimeModule(name).getModule(version)) != null) {
            return null;
        }
        RuntimeModule runtimeModule = this.getRuntimeModule(name);
        Module oldModule = null;
        if (runtimeModule.getModules().isEmpty()) {
            runtimeModule = new RuntimeModule().withName(name).withDefaultVersion(version).addModule(module);
            this.allModules.put(name.toUpperCase(), runtimeModule);
        } else {
            oldModule = runtimeModule.getDefaultModule();
            runtimeModule.addModule(module).setDefaultVersion(version);
            if (oldModule != null && module.getModuleConfig().isNeedUnloadOldVersion() && !runtimeModule.getModules().isEmpty()) {
                runtimeModule.getModules().remove(oldModule.getVersion());
            }
        }
        return oldModule;
    }

    @Override
    public Module remove(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"module name is null");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Remove Module: {}", (Object)name);
        }
        return this.remove(name, this.getRuntimeModule(name).getDefaultVersion());
    }

    @Override
    public Module remove(String name, String version) {
        Preconditions.checkNotNull((Object)name, (Object)"module name is null");
        Preconditions.checkNotNull((Object)version, (Object)"module version is null");
        return this.getRuntimeModule(name).getModules().remove(version);
    }

    public void destroy() throws Exception {
        for (Module each : this.getModules()) {
            try {
                each.destroy();
            }
            catch (Exception e) {
                LOGGER.error("Failed to destroy module: " + each.getName(), (Throwable)e);
            }
        }
        this.allModules.clear();
    }

    @Override
    public Map<String, String> getErrorModuleContext() {
        HashMap result = Maps.newHashMap();
        for (String name : this.allModules.keySet()) {
            RuntimeModule runtimeModule = this.getRuntimeModule(name);
            result.put(name, runtimeModule.getErrorContext());
        }
        return result;
    }
}

