/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.jarslink.api.impl;

import com.alipay.jarslink.api.Module;
import com.alipay.jarslink.api.ModuleConfig;
import com.alipay.jarslink.api.ModuleLoader;
import com.alipay.jarslink.api.ModuleManager;
import com.alipay.jarslink.api.ModuleService;
import com.alipay.jarslink.api.impl.ModuleUtil;
import com.google.common.base.Preconditions;

public class ModuleServiceImpl
implements ModuleService {
    private ModuleManager moduleManager;
    private ModuleLoader moduleLoader;

    @Override
    public Module loadAndRegister(ModuleConfig moduleConfig) {
        Preconditions.checkNotNull((Object)moduleConfig, (Object)"moduleConfig is null");
        if (moduleConfig.getEnabled().booleanValue()) {
            Module module = this.moduleLoader.load(moduleConfig);
            Module oldModule = this.moduleManager.register(module);
            ModuleUtil.destroyQuietly(oldModule);
            return module;
        }
        this.removeModule(moduleConfig.getName());
        return null;
    }

    private Module removeModule(String moduleName) {
        Module removed = this.moduleManager.remove(moduleName);
        ModuleUtil.destroyQuietly(removed);
        return removed;
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public void setModuleLoader(ModuleLoader moduleLoader) {
        this.moduleLoader = moduleLoader;
    }
}

