/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.jarslink.api.impl;

import com.alipay.jarslink.api.Module;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;

public class ModuleUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleUtil.class);
    public static final String MODULE_PROPERTY_PLACEHOLDER_CONFIGURER = "modulePropertyPlaceholderConfigurer";

    static BeanDefinitionRegistry registerModulePropertiesPlaceHolderConfigurer(BeanDefinitionRegistry beanFactory, Properties properties) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(PropertyPlaceholderConfigurer.class);
        beanDefinition.getPropertyValues().add("properties", (Object)properties);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Register: {}", (Object)beanDefinition);
        }
        beanFactory.registerBeanDefinition(MODULE_PROPERTY_PLACEHOLDER_CONFIGURER, (BeanDefinition)beanDefinition);
        return beanFactory;
    }

    static void destroyQuietly(Module module) {
        if (module != null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Destroy module: {}", (Object)module.getName());
                }
                module.destroy();
            }
            catch (Exception e) {
                LOGGER.error("Failed to destroy module " + module, (Throwable)e);
            }
        }
    }
}

