/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.jarslink.api.impl;

import com.alipay.jarslink.api.Action;
import com.alipay.jarslink.api.Module;
import com.alipay.jarslink.api.ModuleConfig;
import com.alipay.jarslink.api.ModuleRuntimeException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.beans.Introspector;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringModule
implements Module {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringModule.class);
    ModuleConfig moduleConfig;
    private final String name;
    private final String version;
    private final Date creation;
    private final Map<String, Action> actions;
    private final ConfigurableApplicationContext applicationContext;

    public SpringModule(ModuleConfig moduleConfig, String version, String name, ConfigurableApplicationContext applicationContext) {
        this.moduleConfig = moduleConfig;
        this.applicationContext = applicationContext;
        this.version = version;
        this.name = name;
        this.creation = new Date();
        this.actions = this.scanActions((ApplicationContext)applicationContext, Action.class, new Function<Action, String>(){

            public String apply(Action input) {
                return input.getActionName();
            }
        });
    }

    private <T> Map<String, T> scanActions(ApplicationContext applicationContext, Class<T> type, Function<T, String> keyFunction) {
        HashMap actions = Maps.newHashMap();
        for (Object action : applicationContext.getBeansOfType(type).values()) {
            String actionName = (String)keyFunction.apply(action);
            if (StringUtils.isBlank((CharSequence)actionName)) {
                throw new ModuleRuntimeException("JarsLink scanActions actionName is null");
            }
            String key = actionName.toUpperCase(Locale.CHINESE);
            Preconditions.checkState((!actions.containsKey(key) ? 1 : 0) != 0, (String)"Duplicated action %s found by: %s", (Object[])new Object[]{type.getSimpleName(), key});
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("JarsLink Scan action: {}: bean: {}", (Object)key, action);
            }
            actions.put(key, action);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("JarsLink Scan actions finish: {}", (Object)ToStringBuilder.reflectionToString((Object)actions));
        }
        return actions;
    }

    @Override
    public Map<String, Action> getActions() {
        return this.actions;
    }

    @Override
    public <R, T> Action<R, T> getAction(String actionName) {
        Preconditions.checkNotNull((Object)actionName, (Object)"actionName is null");
        Action action = this.actions.get(actionName.toUpperCase());
        Preconditions.checkNotNull((Object)action, (Object)("find action is null,actionName=" + actionName));
        return action;
    }

    @Override
    public <R, T> T doAction(String actionName, R actionRequest) {
        Preconditions.checkNotNull((Object)actionName, (Object)"actionName is null");
        Preconditions.checkNotNull(actionRequest, (Object)"actionRequest is null");
        return this.doActionWithinModuleClassLoader(this.getAction(actionName), actionRequest);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected <R, T> T doActionWithinModuleClassLoader(Action<R, T> action, R actionRequest) {
        Preconditions.checkNotNull(action, (Object)"action is null");
        Preconditions.checkNotNull(actionRequest, (Object)"actionRequest is null");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader moduleClassLoader = action.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(moduleClassLoader);
            T t = action.execute(actionRequest);
            return t;
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u6a21\u5757\u51fa\u73b0\u5f02\u5e38,action=" + action, (Throwable)e);
            throw new ModuleRuntimeException("doActionWithinModuleClassLoader has error,action=" + action, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Date getCreation() {
        return this.creation;
    }

    @Override
    public void destroy() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Close application context: {}", (Object)this.applicationContext);
        }
        if (!this.actions.isEmpty()) {
            this.actions.clear();
        }
        SpringModule.closeQuietly(this.applicationContext);
        SpringModule.clear(this.applicationContext.getClassLoader());
    }

    public static void clear(ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader is null");
        Introspector.flushCaches();
        ResourceBundle.clearCache(classLoader);
        CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
        LogFactory.release((ClassLoader)classLoader);
    }

    private static void closeQuietly(ConfigurableApplicationContext applicationContext) {
        Preconditions.checkNotNull((Object)applicationContext, (Object)"applicationContext is null");
        try {
            applicationContext.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close application context", (Throwable)e);
        }
    }

    @Override
    public ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    @Override
    public ClassLoader getChildClassLoader() {
        return this.applicationContext.getClassLoader();
    }
}

