/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayCommerceLogisticsWaybillIstddetailQueryDefaultResponse;
import com.alipay.v3.model.AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayCommerceLogisticsWaybillIstddetailApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayCommerceLogisticsWaybillIstddetailApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayCommerceLogisticsWaybillIstddetailApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call queryCall(String shopNo, String outOrderNo, String orderNo, String logisticsCode, String waybillNo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/commerce/logistics/waybill/istddetail/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (shopNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shop_no", shopNo));
        }
        if (outOrderNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("out_order_no", outOrderNo));
        }
        if (orderNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order_no", orderNo));
        }
        if (logisticsCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logistics_code", logisticsCode));
        }
        if (waybillNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("waybill_no", waybillNo));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String shopNo, String outOrderNo, String orderNo, String logisticsCode, String waybillNo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(shopNo, outOrderNo, orderNo, logisticsCode, waybillNo, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel query(String shopNo, String outOrderNo, String orderNo, String logisticsCode, String waybillNo) throws ApiException {
        ApiResponse<AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel> localVarResp = this.queryWithHttpInfo(shopNo, outOrderNo, orderNo, logisticsCode, waybillNo, null);
        return localVarResp.getData();
    }

    public AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel query(String shopNo, String outOrderNo, String orderNo, String logisticsCode, String waybillNo, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel> localVarResp = this.queryWithHttpInfo(shopNo, outOrderNo, orderNo, logisticsCode, waybillNo, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel> queryWithHttpInfo(String shopNo, String outOrderNo, String orderNo, String logisticsCode, String waybillNo, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(shopNo, outOrderNo, orderNo, logisticsCode, waybillNo, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayCommerceLogisticsWaybillIstddetailQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call queryAsync(String shopNo, String outOrderNo, String orderNo, String logisticsCode, String waybillNo, ApiCallback<AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(shopNo, outOrderNo, orderNo, logisticsCode, waybillNo, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call queryAsync(String shopNo, String outOrderNo, String orderNo, String logisticsCode, String waybillNo, ApiCallback<AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(shopNo, outOrderNo, orderNo, logisticsCode, waybillNo, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayCommerceLogisticsWaybillIstddetailQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

