/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayMarketingActivityDeliveryCreateDefaultResponse;
import com.alipay.v3.model.AlipayMarketingActivityDeliveryCreateModel;
import com.alipay.v3.model.AlipayMarketingActivityDeliveryCreateResponseModel;
import com.alipay.v3.model.AlipayMarketingActivityDeliveryQueryDefaultResponse;
import com.alipay.v3.model.AlipayMarketingActivityDeliveryQueryModel;
import com.alipay.v3.model.AlipayMarketingActivityDeliveryQueryResponseModel;
import com.alipay.v3.model.AlipayMarketingActivityDeliveryStopDefaultResponse;
import com.alipay.v3.model.AlipayMarketingActivityDeliveryStopModel;
import com.alipay.v3.model.AlipayMarketingActivityDeliveryStopResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayMarketingActivityDeliveryApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayMarketingActivityDeliveryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayMarketingActivityDeliveryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCall(AlipayMarketingActivityDeliveryCreateModel alipayMarketingActivityDeliveryCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayMarketingActivityDeliveryCreateModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayMarketingActivityDeliveryCreateModel;
        String localVarPath = "/v3/alipay/marketing/delivery";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(AlipayMarketingActivityDeliveryCreateModel alipayMarketingActivityDeliveryCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createCall(alipayMarketingActivityDeliveryCreateModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingActivityDeliveryCreateResponseModel create(AlipayMarketingActivityDeliveryCreateModel alipayMarketingActivityDeliveryCreateModel) throws ApiException {
        ApiResponse<AlipayMarketingActivityDeliveryCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayMarketingActivityDeliveryCreateModel, null);
        return localVarResp.getData();
    }

    public AlipayMarketingActivityDeliveryCreateResponseModel create(AlipayMarketingActivityDeliveryCreateModel alipayMarketingActivityDeliveryCreateModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingActivityDeliveryCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayMarketingActivityDeliveryCreateModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingActivityDeliveryCreateResponseModel> createWithHttpInfo(AlipayMarketingActivityDeliveryCreateModel alipayMarketingActivityDeliveryCreateModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayMarketingActivityDeliveryCreateModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingActivityDeliveryCreateResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingActivityDeliveryCreateDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call createAsync(AlipayMarketingActivityDeliveryCreateModel alipayMarketingActivityDeliveryCreateModel, ApiCallback<AlipayMarketingActivityDeliveryCreateResponseModel> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayMarketingActivityDeliveryCreateModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingActivityDeliveryCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call createAsync(AlipayMarketingActivityDeliveryCreateModel alipayMarketingActivityDeliveryCreateModel, ApiCallback<AlipayMarketingActivityDeliveryCreateResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayMarketingActivityDeliveryCreateModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingActivityDeliveryCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String deliveryId, AlipayMarketingActivityDeliveryQueryModel alipayMarketingActivityDeliveryQueryModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayMarketingActivityDeliveryQueryModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayMarketingActivityDeliveryQueryModel;
        String localVarPath = "/v3/alipay/marketing/delivery/{delivery_id}/query".replaceAll("\\{delivery_id\\}", this.localVarApiClient.escapeString(deliveryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String deliveryId, AlipayMarketingActivityDeliveryQueryModel alipayMarketingActivityDeliveryQueryModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        if (deliveryId == null) {
            throw new ApiException("Missing the required parameter 'deliveryId' when calling query(Async)");
        }
        Call localVarCall = this.queryCall(deliveryId, alipayMarketingActivityDeliveryQueryModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingActivityDeliveryQueryResponseModel query(String deliveryId, AlipayMarketingActivityDeliveryQueryModel alipayMarketingActivityDeliveryQueryModel) throws ApiException {
        ApiResponse<AlipayMarketingActivityDeliveryQueryResponseModel> localVarResp = this.queryWithHttpInfo(deliveryId, alipayMarketingActivityDeliveryQueryModel, null);
        return localVarResp.getData();
    }

    public AlipayMarketingActivityDeliveryQueryResponseModel query(String deliveryId, AlipayMarketingActivityDeliveryQueryModel alipayMarketingActivityDeliveryQueryModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingActivityDeliveryQueryResponseModel> localVarResp = this.queryWithHttpInfo(deliveryId, alipayMarketingActivityDeliveryQueryModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingActivityDeliveryQueryResponseModel> queryWithHttpInfo(String deliveryId, AlipayMarketingActivityDeliveryQueryModel alipayMarketingActivityDeliveryQueryModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(deliveryId, alipayMarketingActivityDeliveryQueryModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingActivityDeliveryQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingActivityDeliveryQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call queryAsync(String deliveryId, AlipayMarketingActivityDeliveryQueryModel alipayMarketingActivityDeliveryQueryModel, ApiCallback<AlipayMarketingActivityDeliveryQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(deliveryId, alipayMarketingActivityDeliveryQueryModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingActivityDeliveryQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call queryAsync(String deliveryId, AlipayMarketingActivityDeliveryQueryModel alipayMarketingActivityDeliveryQueryModel, ApiCallback<AlipayMarketingActivityDeliveryQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(deliveryId, alipayMarketingActivityDeliveryQueryModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingActivityDeliveryQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call stopCall(String deliveryId, AlipayMarketingActivityDeliveryStopModel alipayMarketingActivityDeliveryStopModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayMarketingActivityDeliveryStopModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayMarketingActivityDeliveryStopModel;
        String localVarPath = "/v3/alipay/marketing/delivery/{delivery_id}/stop".replaceAll("\\{delivery_id\\}", this.localVarApiClient.escapeString(deliveryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stopValidateBeforeCall(String deliveryId, AlipayMarketingActivityDeliveryStopModel alipayMarketingActivityDeliveryStopModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        if (deliveryId == null) {
            throw new ApiException("Missing the required parameter 'deliveryId' when calling stop(Async)");
        }
        Call localVarCall = this.stopCall(deliveryId, alipayMarketingActivityDeliveryStopModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingActivityDeliveryStopResponseModel stop(String deliveryId, AlipayMarketingActivityDeliveryStopModel alipayMarketingActivityDeliveryStopModel) throws ApiException {
        ApiResponse<AlipayMarketingActivityDeliveryStopResponseModel> localVarResp = this.stopWithHttpInfo(deliveryId, alipayMarketingActivityDeliveryStopModel, null);
        return localVarResp.getData();
    }

    public AlipayMarketingActivityDeliveryStopResponseModel stop(String deliveryId, AlipayMarketingActivityDeliveryStopModel alipayMarketingActivityDeliveryStopModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingActivityDeliveryStopResponseModel> localVarResp = this.stopWithHttpInfo(deliveryId, alipayMarketingActivityDeliveryStopModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingActivityDeliveryStopResponseModel> stopWithHttpInfo(String deliveryId, AlipayMarketingActivityDeliveryStopModel alipayMarketingActivityDeliveryStopModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.stopValidateBeforeCall(deliveryId, alipayMarketingActivityDeliveryStopModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingActivityDeliveryStopResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingActivityDeliveryStopDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call stopAsync(String deliveryId, AlipayMarketingActivityDeliveryStopModel alipayMarketingActivityDeliveryStopModel, ApiCallback<AlipayMarketingActivityDeliveryStopResponseModel> _callback) throws ApiException {
        Call localVarCall = this.stopValidateBeforeCall(deliveryId, alipayMarketingActivityDeliveryStopModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingActivityDeliveryStopResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call stopAsync(String deliveryId, AlipayMarketingActivityDeliveryStopModel alipayMarketingActivityDeliveryStopModel, ApiCallback<AlipayMarketingActivityDeliveryStopResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.stopValidateBeforeCall(deliveryId, alipayMarketingActivityDeliveryStopModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingActivityDeliveryStopResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

