/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayPcreditHuabeiAuthOrderQueryDefaultResponse;
import com.alipay.v3.model.AlipayPcreditHuabeiAuthOrderQueryResponseModel;
import com.alipay.v3.model.AlipayPcreditHuabeiAuthOrderUnfreezeDefaultResponse;
import com.alipay.v3.model.AlipayPcreditHuabeiAuthOrderUnfreezeModel;
import com.alipay.v3.model.AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayPcreditHuabeiAuthOrderApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayPcreditHuabeiAuthOrderApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayPcreditHuabeiAuthOrderApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call queryCall(String authOptId, String alipayUserId, String openId, String outRequestNo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/pcredit/huabei/auth/order/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authOptId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("auth_opt_id", authOptId));
        }
        if (alipayUserId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alipay_user_id", alipayUserId));
        }
        if (openId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("open_id", openId));
        }
        if (outRequestNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("out_request_no", outRequestNo));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String authOptId, String alipayUserId, String openId, String outRequestNo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(authOptId, alipayUserId, openId, outRequestNo, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayPcreditHuabeiAuthOrderQueryResponseModel query(String authOptId, String alipayUserId, String openId, String outRequestNo) throws ApiException {
        ApiResponse<AlipayPcreditHuabeiAuthOrderQueryResponseModel> localVarResp = this.queryWithHttpInfo(authOptId, alipayUserId, openId, outRequestNo, null);
        return localVarResp.getData();
    }

    public AlipayPcreditHuabeiAuthOrderQueryResponseModel query(String authOptId, String alipayUserId, String openId, String outRequestNo, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayPcreditHuabeiAuthOrderQueryResponseModel> localVarResp = this.queryWithHttpInfo(authOptId, alipayUserId, openId, outRequestNo, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayPcreditHuabeiAuthOrderQueryResponseModel> queryWithHttpInfo(String authOptId, String alipayUserId, String openId, String outRequestNo, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(authOptId, alipayUserId, openId, outRequestNo, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayPcreditHuabeiAuthOrderQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayPcreditHuabeiAuthOrderQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call queryAsync(String authOptId, String alipayUserId, String openId, String outRequestNo, ApiCallback<AlipayPcreditHuabeiAuthOrderQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(authOptId, alipayUserId, openId, outRequestNo, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayPcreditHuabeiAuthOrderQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call queryAsync(String authOptId, String alipayUserId, String openId, String outRequestNo, ApiCallback<AlipayPcreditHuabeiAuthOrderQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(authOptId, alipayUserId, openId, outRequestNo, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayPcreditHuabeiAuthOrderQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unfreezeCall(AlipayPcreditHuabeiAuthOrderUnfreezeModel alipayPcreditHuabeiAuthOrderUnfreezeModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayPcreditHuabeiAuthOrderUnfreezeModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayPcreditHuabeiAuthOrderUnfreezeModel;
        String localVarPath = "/v3/alipay/pcredit/huabei/auth/order/unfreeze";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unfreezeValidateBeforeCall(AlipayPcreditHuabeiAuthOrderUnfreezeModel alipayPcreditHuabeiAuthOrderUnfreezeModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unfreezeCall(alipayPcreditHuabeiAuthOrderUnfreezeModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel unfreeze(AlipayPcreditHuabeiAuthOrderUnfreezeModel alipayPcreditHuabeiAuthOrderUnfreezeModel) throws ApiException {
        ApiResponse<AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel> localVarResp = this.unfreezeWithHttpInfo(alipayPcreditHuabeiAuthOrderUnfreezeModel, null);
        return localVarResp.getData();
    }

    public AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel unfreeze(AlipayPcreditHuabeiAuthOrderUnfreezeModel alipayPcreditHuabeiAuthOrderUnfreezeModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel> localVarResp = this.unfreezeWithHttpInfo(alipayPcreditHuabeiAuthOrderUnfreezeModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel> unfreezeWithHttpInfo(AlipayPcreditHuabeiAuthOrderUnfreezeModel alipayPcreditHuabeiAuthOrderUnfreezeModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unfreezeValidateBeforeCall(alipayPcreditHuabeiAuthOrderUnfreezeModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayPcreditHuabeiAuthOrderUnfreezeDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call unfreezeAsync(AlipayPcreditHuabeiAuthOrderUnfreezeModel alipayPcreditHuabeiAuthOrderUnfreezeModel, ApiCallback<AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel> _callback) throws ApiException {
        Call localVarCall = this.unfreezeValidateBeforeCall(alipayPcreditHuabeiAuthOrderUnfreezeModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call unfreezeAsync(AlipayPcreditHuabeiAuthOrderUnfreezeModel alipayPcreditHuabeiAuthOrderUnfreezeModel, ApiCallback<AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unfreezeValidateBeforeCall(alipayPcreditHuabeiAuthOrderUnfreezeModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayPcreditHuabeiAuthOrderUnfreezeResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

