/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayTradeAdvanceConsultDefaultResponse;
import com.alipay.v3.model.AlipayTradeAdvanceConsultResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayTradeAdvanceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayTradeAdvanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayTradeAdvanceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call consultCall(String alipayUserId, String consultScene, String industryProductCode, String subMerchantId, String subMerchantType, String agreementNo, String estimatedOrderAmount, String outTradeNo, String needUserRiskPrediction, String tradeDigest, String userOutBindingPhone, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/trade/advance/consult";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (alipayUserId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alipay_user_id", alipayUserId));
        }
        if (consultScene != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("consult_scene", consultScene));
        }
        if (industryProductCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("industry_product_code", industryProductCode));
        }
        if (subMerchantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sub_merchant_id", subMerchantId));
        }
        if (subMerchantType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sub_merchant_type", subMerchantType));
        }
        if (agreementNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("agreement_no", agreementNo));
        }
        if (estimatedOrderAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("estimated_order_amount", estimatedOrderAmount));
        }
        if (outTradeNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("out_trade_no", outTradeNo));
        }
        if (needUserRiskPrediction != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("need_user_risk_prediction", needUserRiskPrediction));
        }
        if (tradeDigest != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("trade_digest", tradeDigest));
        }
        if (userOutBindingPhone != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_out_binding_phone", userOutBindingPhone));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call consultValidateBeforeCall(String alipayUserId, String consultScene, String industryProductCode, String subMerchantId, String subMerchantType, String agreementNo, String estimatedOrderAmount, String outTradeNo, String needUserRiskPrediction, String tradeDigest, String userOutBindingPhone, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.consultCall(alipayUserId, consultScene, industryProductCode, subMerchantId, subMerchantType, agreementNo, estimatedOrderAmount, outTradeNo, needUserRiskPrediction, tradeDigest, userOutBindingPhone, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayTradeAdvanceConsultResponseModel consult(String alipayUserId, String consultScene, String industryProductCode, String subMerchantId, String subMerchantType, String agreementNo, String estimatedOrderAmount, String outTradeNo, String needUserRiskPrediction, String tradeDigest, String userOutBindingPhone) throws ApiException {
        ApiResponse<AlipayTradeAdvanceConsultResponseModel> localVarResp = this.consultWithHttpInfo(alipayUserId, consultScene, industryProductCode, subMerchantId, subMerchantType, agreementNo, estimatedOrderAmount, outTradeNo, needUserRiskPrediction, tradeDigest, userOutBindingPhone, null);
        return localVarResp.getData();
    }

    public AlipayTradeAdvanceConsultResponseModel consult(String alipayUserId, String consultScene, String industryProductCode, String subMerchantId, String subMerchantType, String agreementNo, String estimatedOrderAmount, String outTradeNo, String needUserRiskPrediction, String tradeDigest, String userOutBindingPhone, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayTradeAdvanceConsultResponseModel> localVarResp = this.consultWithHttpInfo(alipayUserId, consultScene, industryProductCode, subMerchantId, subMerchantType, agreementNo, estimatedOrderAmount, outTradeNo, needUserRiskPrediction, tradeDigest, userOutBindingPhone, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayTradeAdvanceConsultResponseModel> consultWithHttpInfo(String alipayUserId, String consultScene, String industryProductCode, String subMerchantId, String subMerchantType, String agreementNo, String estimatedOrderAmount, String outTradeNo, String needUserRiskPrediction, String tradeDigest, String userOutBindingPhone, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.consultValidateBeforeCall(alipayUserId, consultScene, industryProductCode, subMerchantId, subMerchantType, agreementNo, estimatedOrderAmount, outTradeNo, needUserRiskPrediction, tradeDigest, userOutBindingPhone, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayTradeAdvanceConsultResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayTradeAdvanceConsultDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call consultAsync(String alipayUserId, String consultScene, String industryProductCode, String subMerchantId, String subMerchantType, String agreementNo, String estimatedOrderAmount, String outTradeNo, String needUserRiskPrediction, String tradeDigest, String userOutBindingPhone, ApiCallback<AlipayTradeAdvanceConsultResponseModel> _callback) throws ApiException {
        Call localVarCall = this.consultValidateBeforeCall(alipayUserId, consultScene, industryProductCode, subMerchantId, subMerchantType, agreementNo, estimatedOrderAmount, outTradeNo, needUserRiskPrediction, tradeDigest, userOutBindingPhone, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayTradeAdvanceConsultResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call consultAsync(String alipayUserId, String consultScene, String industryProductCode, String subMerchantId, String subMerchantType, String agreementNo, String estimatedOrderAmount, String outTradeNo, String needUserRiskPrediction, String tradeDigest, String userOutBindingPhone, ApiCallback<AlipayTradeAdvanceConsultResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.consultValidateBeforeCall(alipayUserId, consultScene, industryProductCode, subMerchantId, subMerchantType, agreementNo, estimatedOrderAmount, outTradeNo, needUserRiskPrediction, tradeDigest, userOutBindingPhone, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayTradeAdvanceConsultResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

