/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayTradeBatchSettleDefaultResponse;
import com.alipay.v3.model.AlipayTradeBatchSettleModel;
import com.alipay.v3.model.AlipayTradeBatchSettleResponseModel;
import com.alipay.v3.model.AlipayTradeBatchTransferDefaultResponse;
import com.alipay.v3.model.AlipayTradeBatchTransferModel;
import com.alipay.v3.model.AlipayTradeBatchTransferResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayTradeBatchApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayTradeBatchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayTradeBatchApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call settleCall(AlipayTradeBatchSettleModel alipayTradeBatchSettleModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayTradeBatchSettleModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayTradeBatchSettleModel;
        String localVarPath = "/v3/alipay/trade/batch/settle";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call settleValidateBeforeCall(AlipayTradeBatchSettleModel alipayTradeBatchSettleModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.settleCall(alipayTradeBatchSettleModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayTradeBatchSettleResponseModel settle(AlipayTradeBatchSettleModel alipayTradeBatchSettleModel) throws ApiException {
        ApiResponse<AlipayTradeBatchSettleResponseModel> localVarResp = this.settleWithHttpInfo(alipayTradeBatchSettleModel, null);
        return localVarResp.getData();
    }

    public AlipayTradeBatchSettleResponseModel settle(AlipayTradeBatchSettleModel alipayTradeBatchSettleModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayTradeBatchSettleResponseModel> localVarResp = this.settleWithHttpInfo(alipayTradeBatchSettleModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayTradeBatchSettleResponseModel> settleWithHttpInfo(AlipayTradeBatchSettleModel alipayTradeBatchSettleModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.settleValidateBeforeCall(alipayTradeBatchSettleModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayTradeBatchSettleResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayTradeBatchSettleDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call settleAsync(AlipayTradeBatchSettleModel alipayTradeBatchSettleModel, ApiCallback<AlipayTradeBatchSettleResponseModel> _callback) throws ApiException {
        Call localVarCall = this.settleValidateBeforeCall(alipayTradeBatchSettleModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayTradeBatchSettleResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call settleAsync(AlipayTradeBatchSettleModel alipayTradeBatchSettleModel, ApiCallback<AlipayTradeBatchSettleResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.settleValidateBeforeCall(alipayTradeBatchSettleModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayTradeBatchSettleResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call transferCall(AlipayTradeBatchTransferModel alipayTradeBatchTransferModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayTradeBatchTransferModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayTradeBatchTransferModel;
        String localVarPath = "/v3/alipay/trade/batch/transfer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transferValidateBeforeCall(AlipayTradeBatchTransferModel alipayTradeBatchTransferModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.transferCall(alipayTradeBatchTransferModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayTradeBatchTransferResponseModel transfer(AlipayTradeBatchTransferModel alipayTradeBatchTransferModel) throws ApiException {
        ApiResponse<AlipayTradeBatchTransferResponseModel> localVarResp = this.transferWithHttpInfo(alipayTradeBatchTransferModel, null);
        return localVarResp.getData();
    }

    public AlipayTradeBatchTransferResponseModel transfer(AlipayTradeBatchTransferModel alipayTradeBatchTransferModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayTradeBatchTransferResponseModel> localVarResp = this.transferWithHttpInfo(alipayTradeBatchTransferModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayTradeBatchTransferResponseModel> transferWithHttpInfo(AlipayTradeBatchTransferModel alipayTradeBatchTransferModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.transferValidateBeforeCall(alipayTradeBatchTransferModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayTradeBatchTransferResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayTradeBatchTransferDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call transferAsync(AlipayTradeBatchTransferModel alipayTradeBatchTransferModel, ApiCallback<AlipayTradeBatchTransferResponseModel> _callback) throws ApiException {
        Call localVarCall = this.transferValidateBeforeCall(alipayTradeBatchTransferModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayTradeBatchTransferResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call transferAsync(AlipayTradeBatchTransferModel alipayTradeBatchTransferModel, ApiCallback<AlipayTradeBatchTransferResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.transferValidateBeforeCall(alipayTradeBatchTransferModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayTradeBatchTransferResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

