/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.util;

import com.alipay.v3.ApiException;
import com.alipay.v3.util.AlipayConfigUtil;
import com.alipay.v3.util.AntCertificationUtil;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class AlipaySignature {
    public static String sign(String content, String privateKey, String charset, String signType) throws ApiException {
        if (!Strings.isNullOrEmpty((String)charset) && !"utf-8".equalsIgnoreCase(charset)) {
            throw new ApiException("charset\u53ea\u652f\u6301utf-8");
        }
        if (!Strings.isNullOrEmpty((String)signType) && !"RSA2".equalsIgnoreCase(signType)) {
            throw new ApiException("signType\u53ea\u652f\u6301RSA2");
        }
        AlipayConfigUtil alipayConfigUtil = new AlipayConfigUtil();
        alipayConfigUtil.setPrivateKey(privateKey);
        return alipayConfigUtil.generateSign(content);
    }

    public static String sign(Map<String, String> params, String privateKey, String charset, String signType) throws ApiException {
        String signContent = AlipaySignature.getSignContent(params);
        return AlipaySignature.sign(signContent, privateKey, charset, signType);
    }

    public static boolean verifyV1(Map<String, String> params, String publicKey, String charset, String signType) throws ApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV1(params);
        return AlipaySignature.verify(content, sign, publicKey, charset, signType);
    }

    public static boolean certVerifyV1(Map<String, String> params, String alipayPublicCertPath, String charset, String signType) throws ApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.verifyV1(params, publicKey, charset, signType);
    }

    public static boolean verifyV2(Map<String, String> params, String publicKey, String charset, String signType) throws ApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV2(params);
        return AlipaySignature.verify(content, sign, publicKey, charset, signType);
    }

    public static boolean certVerifyV2(Map<String, String> params, String alipayPublicCertPath, String charset, String signType) throws ApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.verifyV2(params, publicKey, charset, signType);
    }

    public static boolean verify(String content, String sign, String publicKey, String charset, String signType) throws ApiException {
        if (!Strings.isNullOrEmpty((String)charset) && !"utf-8".equalsIgnoreCase(charset)) {
            throw new ApiException("charset\u53ea\u652f\u6301utf-8");
        }
        if (!Strings.isNullOrEmpty((String)signType) && !"RSA2".equalsIgnoreCase(signType)) {
            throw new ApiException("signType\u53ea\u652f\u6301RSA2");
        }
        AlipayConfigUtil alipayConfigUtil = new AlipayConfigUtil();
        return alipayConfigUtil.generateVerify(content, sign, publicKey);
    }

    public static boolean certVerify(String content, String sign, String alipayPublicCertPath, String charset, String signType) throws ApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.verify(content, sign, publicKey, charset, signType);
    }

    public static String encrypt(String content, String publicKey, String charset, String signType) throws ApiException {
        if (!Strings.isNullOrEmpty((String)charset) && !"utf-8".equalsIgnoreCase(charset)) {
            throw new ApiException("charset\u53ea\u652f\u6301utf-8");
        }
        if (!Strings.isNullOrEmpty((String)signType) && !"RSA2".equalsIgnoreCase(signType)) {
            throw new ApiException("signType\u53ea\u652f\u6301RSA2");
        }
        AlipayConfigUtil alipayConfigUtil = new AlipayConfigUtil();
        alipayConfigUtil.setAlipayPublicKey(publicKey);
        return alipayConfigUtil.doEncrypt(content);
    }

    public static String decrypt(String content, String privateKey, String charset, String signType) throws ApiException {
        if (!Strings.isNullOrEmpty((String)charset) && !"utf-8".equalsIgnoreCase(charset)) {
            throw new ApiException("charset\u53ea\u652f\u6301utf-8");
        }
        if (!Strings.isNullOrEmpty((String)signType) && !"RSA2".equalsIgnoreCase(signType)) {
            throw new ApiException("signType\u53ea\u652f\u6301RSA2");
        }
        AlipayConfigUtil alipayConfigUtil = new AlipayConfigUtil();
        alipayConfigUtil.setPrivateKey(privateKey);
        return alipayConfigUtil.doDecrypt(content);
    }

    public static String encryptAndSign(String bizContent, String alipayPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign, String signType) throws ApiException {
        StringBuilder sb = new StringBuilder();
        if (Strings.isNullOrEmpty((String)charset)) {
            charset = "utf-8";
        }
        sb.append("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
        if (isEncrypt) {
            sb.append("<alipay>");
            String encrypted = AlipaySignature.encrypt(bizContent, alipayPublicKey, charset, signType);
            sb.append("<response>" + encrypted + "</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = AlipaySignature.sign(encrypted, cusPrivateKey, charset, signType);
                sb.append("<sign>" + sign + "</sign>");
                sb.append("<sign_type>RSA</sign_type>");
            }
            sb.append("</alipay>");
        } else if (isSign) {
            sb.append("<alipay>");
            sb.append("<response>" + bizContent + "</response>");
            String sign = AlipaySignature.sign(bizContent, cusPrivateKey, charset, signType);
            sb.append("<sign>" + sign + "</sign>");
            sb.append("<sign_type>RSA</sign_type>");
            sb.append("</alipay>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    public static String checkSignAndDecrypt(Map<String, String> params, String alipayPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt, String signType) throws ApiException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !AlipaySignature.verifyV2(params, alipayPublicKey, charset, signType)) {
            throw new ApiException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return AlipaySignature.decrypt(bizContent, cusPrivateKey, charset, signType);
        }
        return bizContent;
    }

    public static String getSignContent(Map<String, String> sortedParams) {
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = sortedParams.get(key);
            if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)value)) continue;
            content.append(index == 0 ? "" : "&").append(key).append("=").append(value);
            ++index;
        }
        return content.toString();
    }

    @Deprecated
    public static String rsaSign(String content, String privateKey, String charset, String signType) throws ApiException {
        return AlipaySignature.sign(content, privateKey, charset, signType);
    }

    @Deprecated
    public static String rsa256Sign(String content, String privateKey, String charset) throws ApiException {
        return AlipaySignature.sign(content, privateKey, charset, "RSA2");
    }

    @Deprecated
    public static String rsaSign(String content, String privateKey, String charset) throws ApiException {
        return AlipaySignature.sign(content, privateKey, charset, "RSA");
    }

    @Deprecated
    public static String rsaSign(Map<String, String> params, String privateKey, String charset) throws ApiException {
        String signContent = AlipaySignature.getSignContent(params);
        return AlipaySignature.rsaSign(signContent, privateKey, charset);
    }

    public static String getSignCheckContentV1(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        params.remove("sign_type");
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)value)) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }

    public static String getSignCheckContentV2(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)value)) continue;
            content.append(index == 0 ? "" : "&").append(key).append("=").append(value);
            ++index;
        }
        return content.toString();
    }

    @Deprecated
    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset) throws ApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV1(params);
        return AlipaySignature.rsaCheckContent(content, sign, publicKey, charset);
    }

    @Deprecated
    public static boolean rsaCertCheckV1(Map<String, String> params, String alipayPublicCertPath, String charset) throws ApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.rsaCheckV1(params, publicKey, charset);
    }

    @Deprecated
    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset, String signType) throws ApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV1(params);
        return AlipaySignature.rsaCheck(content, sign, publicKey, charset, signType);
    }

    @Deprecated
    public static boolean rsaCertCheckV1(Map<String, String> params, String alipayPublicCertPath, String charset, String signType) throws ApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.rsaCheckV1(params, publicKey, charset, signType);
    }

    @Deprecated
    public static boolean rsaCheckV2(Map<String, String> params, String publicKey, String charset) throws ApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV2(params);
        return AlipaySignature.rsaCheckContent(content, sign, publicKey, charset);
    }

    @Deprecated
    public static boolean rsaCertCheckV2(Map<String, String> params, String alipayPublicCertPath, String charset) throws ApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.rsaCheckV2(params, publicKey, charset);
    }

    @Deprecated
    public static boolean rsaCheckV2(Map<String, String> params, String publicKey, String charset, String signType) throws ApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV2(params);
        return AlipaySignature.rsaCheck(content, sign, publicKey, charset, signType);
    }

    @Deprecated
    public static boolean rsaCertCheckV2(Map<String, String> params, String alipayPublicCertPath, String charset, String signType) throws ApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.rsaCheckV2(params, publicKey, charset, signType);
    }

    @Deprecated
    public static boolean rsaCheck(String content, String sign, String publicKey, String charset, String signType) throws ApiException {
        return AlipaySignature.verify(content, sign, publicKey, charset, signType);
    }

    @Deprecated
    public static boolean rsaCertCheck(String content, String sign, String alipayPublicCertPath, String charset, String signType) throws ApiException {
        String publicKey = AlipaySignature.getAlipayPublicKey(alipayPublicCertPath);
        return AlipaySignature.rsaCheck(content, sign, publicKey, charset, signType);
    }

    @Deprecated
    public static boolean rsa256CheckContent(String content, String sign, String publicKey, String charset) throws ApiException {
        return AlipaySignature.verify(content, sign, publicKey, charset, "RSA2");
    }

    @Deprecated
    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws ApiException {
        return AlipaySignature.verify(content, sign, publicKey, charset, "RSA");
    }

    @Deprecated
    public static String checkSignAndDecrypt(Map<String, String> params, String alipayPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt) throws ApiException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !AlipaySignature.rsaCheckV2(params, alipayPublicKey, charset)) {
            throw new ApiException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return AlipaySignature.rsaDecrypt(bizContent, cusPrivateKey, charset);
        }
        return bizContent;
    }

    @Deprecated
    public static String encryptAndSign(String bizContent, String alipayPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign) throws ApiException {
        StringBuilder sb = new StringBuilder();
        if (Strings.isNullOrEmpty((String)charset)) {
            charset = "utf-8";
        }
        sb.append("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
        if (isEncrypt) {
            sb.append("<alipay>");
            String encrypted = AlipaySignature.rsaEncrypt(bizContent, alipayPublicKey, charset);
            sb.append("<response>" + encrypted + "</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = AlipaySignature.rsaSign(encrypted, cusPrivateKey, charset);
                sb.append("<sign>" + sign + "</sign>");
                sb.append("<sign_type>RSA</sign_type>");
            }
            sb.append("</alipay>");
        } else if (isSign) {
            sb.append("<alipay>");
            sb.append("<response>" + bizContent + "</response>");
            String sign = AlipaySignature.rsaSign(bizContent, cusPrivateKey, charset);
            sb.append("<sign>" + sign + "</sign>");
            sb.append("<sign_type>RSA</sign_type>");
            sb.append("</alipay>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    @Deprecated
    public static String rsaEncrypt(String content, String publicKey, String charset) throws ApiException {
        return AlipaySignature.encrypt(content, publicKey, charset, "RSA");
    }

    @Deprecated
    public static String rsaDecrypt(String content, String privateKey, String charset) throws ApiException {
        return AlipaySignature.decrypt(content, privateKey, charset, "RSA");
    }

    public static String getCertSN(String certPath) {
        return AntCertificationUtil.getCertSN(AntCertificationUtil.readCertContent(certPath));
    }

    public static String getAlipayPublicKey(String alipayPublicCertPath) {
        return AntCertificationUtil.getCertPublicKey(AntCertificationUtil.readCertContent(alipayPublicCertPath));
    }
}

