/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.util;

import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.util.StreamCallback;
import com.alipay.v3.util.model.CustomizedParams;
import com.alipay.v3.util.model.OpenApiGenericRequest;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import okhttp3.Call;
import okhttp3.Request;

public class GenericExecuteApi {
    private ApiClient localVarApiClient;
    private String localCustomBaseUrl;
    private boolean loadTest = false;

    public GenericExecuteApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GenericExecuteApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getLocalVarApiClient() {
        return this.localVarApiClient;
    }

    public void setLocalVarApiClient(ApiClient localVarApiClient) {
        this.localVarApiClient = localVarApiClient;
    }

    public String getLocalCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setLocalCustomBaseUrl(String localCustomBaseUrl) {
        this.localCustomBaseUrl = localCustomBaseUrl;
    }

    public boolean isLoadTest() {
        return this.loadTest;
    }

    public void setLoadTest(boolean loadTest) {
        this.loadTest = loadTest;
    }

    public ApiResponse<Object> execute(String path, String method, OpenApiGenericRequest openApiGenericRequest) throws ApiException {
        Request request = this.buildRequest(path, method, openApiGenericRequest);
        Call localVarCall = this.localVarApiClient.buildCall(request);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public <T> ApiResponse<T> execute(String path, String method, OpenApiGenericRequest openApiGenericRequest, TypeToken<T> type) throws ApiException {
        Request request = this.buildRequest(path, method, openApiGenericRequest);
        Call localVarCall = this.localVarApiClient.buildCall(request);
        return this.localVarApiClient.execute(localVarCall, type.getType());
    }

    public String pageExecute(String method, String httpMethod, Map<String, Object> bizParams) throws ApiException {
        return this.pageExecute(method, httpMethod, bizParams, null, null, null);
    }

    public String pageExecute(String method, String httpMethod, Map<String, Object> bizParams, String authToken, String appAuthToken, CustomizedParams customizedParams) throws ApiException {
        HashMap<String, String> appParams = new HashMap<String, String>();
        HashMap<String, String> systemParams = new HashMap<String, String>();
        this.handleParams(appParams, systemParams, bizParams, authToken, appAuthToken, customizedParams);
        Map<String, String> sortedMap = this.localVarApiClient.getSortedMap(method, appParams, systemParams);
        if (this.loadTest && systemParams.containsKey("app_id")) {
            String appId = (String)systemParams.get("app_id") + "_TEST_1A";
            systemParams.put("app_id", appId);
            sortedMap.put("app_id", appId);
        }
        if ("GET".equalsIgnoreCase(httpMethod)) {
            return this.getRedirectUrl(sortedMap, true);
        }
        return this.getRequestUrl(appParams, systemParams);
    }

    public String sdkExecute(String method, Map<String, Object> bizParams) throws ApiException {
        return this.sdkExecute(method, bizParams, null, null, null);
    }

    public String sdkExecute(String method, Map<String, Object> bizParams, String authToken, String appAuthToken, CustomizedParams customizedParams) throws ApiException {
        HashMap<String, String> appParams = new HashMap<String, String>();
        HashMap<String, String> systemParams = new HashMap<String, String>();
        this.handleParams(appParams, systemParams, bizParams, authToken, appAuthToken, customizedParams);
        Map<String, String> sortedMap = this.localVarApiClient.getSortedMap(method, appParams, systemParams);
        if (this.loadTest && sortedMap.containsKey("app_id")) {
            String appId = sortedMap.get("app_id") + "_TEST_1A";
            sortedMap.put("app_id", appId);
        }
        return this.getRedirectUrl(sortedMap, false);
    }

    public <T> void streamExecute(String path, String method, OpenApiGenericRequest openApiGenericRequest, StreamCallback<T> callback) throws ApiException {
        Request request = this.buildRequest(path, method, openApiGenericRequest);
        this.localVarApiClient.streamCall(request, callback);
    }

    private Request buildRequest(String path, String method, OpenApiGenericRequest openApiGenericRequest) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        boolean isFileUpload;
        boolean bl = isFileUpload = openApiGenericRequest.getFileParams() != null && openApiGenericRequest.getFileParams().size() > 0 || openApiGenericRequest.getByteStreamParams() != null && openApiGenericRequest.getByteStreamParams().size() > 0;
        if (openApiGenericRequest.getBodyParams() == null) {
            openApiGenericRequest.setBodyParams(openApiGenericRequest.getBizParams());
        }
        Map<String, Object> localVarPostBody = isFileUpload || "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) ? null : openApiGenericRequest.getBodyParams();
        String localVarPath = path;
        if (openApiGenericRequest.getPathParams() != null && openApiGenericRequest.getPathParams().size() > 0) {
            for (Map.Entry<String, Object> entry : openApiGenericRequest.getPathParams().entrySet()) {
                localVarPath = localVarPath.replaceAll("\\{" + entry.getKey() + "\\}", this.localVarApiClient.escapeString(entry.getValue().toString()));
            }
        }
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (openApiGenericRequest.getQueryParams() != null && openApiGenericRequest.getQueryParams().size() > 0) {
            for (Map.Entry<String, Object> entry : openApiGenericRequest.getQueryParams().entrySet()) {
                localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
            }
        }
        if (isFileUpload) {
            if (openApiGenericRequest.getBodyParams() != null) {
                localVarFormParams.put("data", openApiGenericRequest.getBodyParams());
            }
            if (openApiGenericRequest.getFileParams() != null) {
                localVarFormParams.putAll(openApiGenericRequest.getFileParams());
            }
            if (openApiGenericRequest.getByteStreamParams() != null) {
                localVarFormParams.putAll(openApiGenericRequest.getByteStreamParams());
            }
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{isFileUpload ? "multipart/form-data" : "application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (!Strings.isNullOrEmpty((String)openApiGenericRequest.getAppAuthToken())) {
            localVarHeaderParams.put("alipay-app-auth-token", openApiGenericRequest.getAppAuthToken());
        }
        if (openApiGenericRequest.getHeaderParams() != null && openApiGenericRequest.getHeaderParams().size() > 0) {
            localVarHeaderParams.putAll(openApiGenericRequest.getHeaderParams());
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildRequest(this.localCustomBaseUrl, localVarPath, method.toUpperCase(), localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, null);
    }

    private void handleParams(Map<String, String> appParams, Map<String, String> systemParams, Map<String, Object> bizParams, String authToken, String appAuthToken, CustomizedParams customizedParams) {
        if (customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent())) {
            appParams.put("biz_content", customizedParams.getBodyContent());
        } else if (bizParams != null && bizParams.containsKey("biz_content")) {
            appParams.put("biz_content", JSON.serialize(bizParams.get("biz_content")));
        }
        if (bizParams != null) {
            for (Map.Entry<String, Object> pair : bizParams.entrySet()) {
                if ("biz_content".equals(pair.getKey())) continue;
                appParams.put(pair.getKey(), this.localVarApiClient.parameterToString(pair.getValue()));
            }
        }
        if (customizedParams != null) {
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                appParams.put("app_auth_token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getQueryParams() != null) {
                systemParams.putAll(customizedParams.getQueryParams());
            }
        }
        if (!Strings.isNullOrEmpty((String)appAuthToken)) {
            appParams.put("app_auth_token", appAuthToken);
        }
        if (!Strings.isNullOrEmpty((String)authToken)) {
            systemParams.put("auth_token", authToken);
        }
    }

    private String getRedirectUrl(Map<String, String> sortedMap, boolean isNeedUrl) {
        return this.localVarApiClient.buildQuery(sortedMap, this.localCustomBaseUrl, isNeedUrl);
    }

    private String getRequestUrl(Map<String, String> appParams, Map<String, String> systemParams) {
        String baseUrl = this.localVarApiClient.buildQuery(systemParams, this.localCustomBaseUrl, true);
        return this.buildForm(baseUrl, appParams);
    }

    private String buildForm(String baseUrl, Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("<form name=\"punchout_form\" method=\"post\" action=\"");
        sb.append(baseUrl);
        sb.append("\">\n");
        sb.append(this.buildHiddenFields(parameters));
        sb.append("<input type=\"submit\" value=\"\u7acb\u5373\u652f\u4ed8\" style=\"display:none\" >\n");
        sb.append("</form>\n");
        sb.append("<script>document.forms[0].submit();</script>");
        return sb.toString();
    }

    private String buildHiddenFields(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Set<String> keys = parameters.keySet();
        for (String key : keys) {
            String value = parameters.get(key);
            if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)value)) continue;
            sb.append(this.buildHiddenField(key, value));
        }
        return sb.toString();
    }

    private String buildHiddenField(String key, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("<input type=\"hidden\" name=\"");
        sb.append(key);
        sb.append("\" value=\"");
        String a = value.replace("\"", "&quot;");
        sb.append(a).append("\">\n");
        return sb.toString();
    }
}

