/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.util.model;

public class ByteStreamWrapper {
    private String fileName;
    private byte[] content;
    private String mimeType;

    public ByteStreamWrapper(String fileName, byte[] content) {
        this.fileName = fileName;
        this.content = content;
    }

    public ByteStreamWrapper(String fileName, byte[] content, String mimeType) {
        this(fileName, content);
        this.mimeType = mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            return this.getRealMimeType(this.content);
        }
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    private String getRealMimeType(byte[] bytes) {
        String suffix = this.getFileSuffix(bytes);
        if ("JPG".equals(suffix)) {
            return "image/jpeg";
        }
        if ("GIF".equals(suffix)) {
            return "image/gif";
        }
        if ("PNG".equals(suffix)) {
            return "image/png";
        }
        if ("BMP".equals(suffix)) {
            return "image/bmp";
        }
        return "application/octet-stream";
    }

    private String getFileSuffix(byte[] bytes) {
        if (bytes == null || bytes.length < 10) {
            return null;
        }
        if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "GIF";
        }
        if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "PNG";
        }
        if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "JPG";
        }
        if (bytes[0] == 66 && bytes[1] == 77) {
            return "BMP";
        }
        return null;
    }
}

