/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.msg;

import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.json.ExceptionErrorListener;
import com.alipay.api.internal.util.json.JSONReader;
import com.alipay.api.internal.util.json.JSONValidatingReader;
import com.alipay.api.internal.util.json.JSONValidatingWriter;
import com.alipay.api.internal.util.json.JSONValidator;
import com.alipay.api.internal.util.json.JSONWriter;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Message
implements Serializable {
    private static final long serialVersionUID = 8280401559432634875L;
    private static final Pattern DATA_PATTERN = Pattern.compile("\"data\"\\s*:\\s*\\{");
    private String xType = "message";
    private String xCmd;
    private String xMessageId;
    private String xStatus;
    private String xCode;
    private String xError;
    private String xSignType;
    private String xSign;
    private String xCharset;
    private Long xTimestamp;
    private String xVersion = "1.0";
    private String appId;
    private String msgApi;
    private String bizContent;
    private String body;

    public static Message fromStr(String str) throws IllegalArgumentException {
        Message message = new Message();
        message.setBody(str);
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(str);
        if (!(rootObj instanceof Map)) {
            throw new IllegalArgumentException("json format illegal.");
        }
        Map rootJson = (Map)rootObj;
        if (!rootJson.containsKey("protocol")) {
            throw new IllegalArgumentException("miss protocol part.");
        }
        if (!(rootJson.get("protocol") instanceof Map)) {
            throw new IllegalArgumentException("protocol part format illegal.");
        }
        Map protocolJson = (Map)rootJson.get("protocol");
        message.setxType((String)protocolJson.get("x-type"));
        if (StringUtils.isEmpty(message.getxType())) {
            throw new IllegalArgumentException("miss x-type in protocol part.");
        }
        message.setxCmd((String)protocolJson.get("x-cmd"));
        message.setxMessageId((String)protocolJson.get("x-msgId"));
        message.setxStatus((String)protocolJson.get("x-status"));
        message.setxCode((String)protocolJson.get("x-code"));
        message.setxError((String)protocolJson.get("x-error"));
        message.setxCharset((String)protocolJson.get("x-charset"));
        message.setxSignType((String)protocolJson.get("x-signType"));
        message.setxSign((String)protocolJson.get("x-sign"));
        if (protocolJson.containsKey("x-timestamp")) {
            Long xTimestamp = null;
            String sTimestamp = (String)protocolJson.get("x-timestamp");
            try {
                xTimestamp = Long.parseLong(sTimestamp);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("x-timestamp format illegal. " + sTimestamp);
            }
            message.setxTimestamp(xTimestamp);
        }
        message.setxVersion((String)protocolJson.get("x-version"));
        if (rootJson.containsKey("data")) {
            if (!(rootJson.get("data") instanceof Map)) {
                throw new IllegalArgumentException("data part format illegal.");
            }
            Map dataJson = (Map)rootJson.get("data");
            if (dataJson.containsKey("header")) {
                if (!(dataJson.get("header") instanceof Map)) {
                    throw new IllegalArgumentException("header part format illegal.");
                }
                Map headerJson = (Map)dataJson.get("header");
                message.setAppId((String)headerJson.get("appId"));
                message.setMsgApi((String)headerJson.get("msgApi"));
            }
            if (dataJson.containsKey("content")) {
                if (!(dataJson.get("content") instanceof Map)) {
                    throw new IllegalArgumentException("content part format illegal.");
                }
                JSONValidatingWriter writer = new JSONValidatingWriter(new ExceptionErrorListener());
                message.setBizContent(((JSONWriter)writer).write(dataJson.get("content")));
            }
        }
        return message;
    }

    public static String toStr(Message message) throws IllegalArgumentException {
        if (message == null) {
            return null;
        }
        if (!StringUtils.isEmpty(message.getBody())) {
            return message.getBody();
        }
        if (StringUtils.isEmpty(message.getxType())) {
            throw new IllegalArgumentException("xType required. " + message);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\"protocol\":{");
        sb.append("\"x-type\":\"").append(message.getxType()).append("\",");
        if (!StringUtils.isEmpty(message.getxCmd())) {
            sb.append("\"x-cmd\":\"").append(message.getxCmd()).append("\",");
        }
        if (!StringUtils.isEmpty(message.getxMessageId())) {
            sb.append("\"x-msgId\":\"").append(message.getxMessageId()).append("\",");
        }
        if (message.getxTimestamp() != null) {
            sb.append("\"x-timestamp\":\"").append(message.getxTimestamp()).append("\",");
        }
        if (!StringUtils.isEmpty(message.getxVersion())) {
            sb.append("\"x-version\":\"").append(message.getxVersion()).append("\",");
        }
        if (!StringUtils.isEmpty(message.getxStatus())) {
            sb.append("\"x-status\":\"").append(message.getxStatus()).append("\",");
        }
        if (!StringUtils.isEmpty(message.getxCode())) {
            sb.append("\"x-code\":\"").append(message.getxCode()).append("\",");
        }
        if (!StringUtils.isEmpty(message.getxError())) {
            sb.append("\"x-error\":\"").append(message.getxError()).append("\",");
        }
        if (!StringUtils.isEmpty(message.getxCharset())) {
            sb.append("\"x-charset\":\"").append(message.getxCharset()).append("\",");
        }
        if (!StringUtils.isEmpty(message.getxSignType())) {
            sb.append("\"x-signType\":\"").append(message.getxSignType()).append("\",");
        }
        if (!StringUtils.isEmpty(message.getxSign())) {
            sb.append("\"x-sign\":\"").append(message.getxSign()).append("\",");
        }
        if (',' == sb.charAt(sb.length() - 1)) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        String data = Message.genDataPart(message);
        if (data != null) {
            sb.append(",\"data\":").append(data);
        }
        sb.append("}");
        message.setBody(sb.toString());
        return message.getBody();
    }

    public static boolean checkSign(Message message, String alipayPublicKey) throws IllegalArgumentException {
        if (!"message".equals(message.getxType()) || !"CONSUME".equals(message.getxCmd())) {
            return true;
        }
        if (StringUtils.isEmpty(message.getxSignType()) || StringUtils.isEmpty(message.getxSign()) || StringUtils.isEmpty(message.getxCharset()) || StringUtils.isEmpty(alipayPublicKey)) {
            throw new IllegalArgumentException("can not check sign, miss x-signType or x-sign or x-charset.");
        }
        String signContent = Message.extractSignContent(message.getBody());
        if (StringUtils.isEmpty(signContent)) {
            throw new IllegalArgumentException("can not check sign, miss signContent.");
        }
        try {
            return AlipaySignature.rsaCheck(signContent, message.getxSign(), alipayPublicKey, message.getxCharset(), message.getxSignType());
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("check sign fail. exception:" + t.getCause().getMessage());
        }
    }

    public static void addSign(Message message, String appPrivateKey) {
        if (!"message".equals(message.getxType()) || !"PRODUCE".equals(message.getxCmd())) {
            return;
        }
        if (StringUtils.isEmpty(message.getxSignType()) || StringUtils.isEmpty(message.getxCharset()) || StringUtils.isEmpty(appPrivateKey)) {
            throw new IllegalArgumentException("can not add sign, miss x-signType or x-charset.");
        }
        String signContent = Message.genDataPart(message);
        if (StringUtils.isEmpty(signContent)) {
            throw new IllegalArgumentException("can not add sign, miss signContent.");
        }
        try {
            message.setxSign(AlipaySignature.rsaSign(signContent, appPrivateKey, message.getxCharset(), message.getxSignType()));
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("add sign fail. exception:" + t.getMessage());
        }
    }

    private static String extractSignContent(String str) {
        if (str == null) {
            return null;
        }
        Matcher m = DATA_PATTERN.matcher(str);
        if (!m.find()) {
            return null;
        }
        int begin = m.end() - 1;
        int end = -1;
        int size = str.length();
        boolean clean = true;
        for (int i = begin + 1; i < size; ++i) {
            if (str.charAt(i) == '{') {
                clean = false;
                continue;
            }
            if (str.charAt(i) != '}') continue;
            if (clean) {
                end = i + 1;
                break;
            }
            clean = true;
        }
        return str.substring(begin, end);
    }

    private static String genDataPart(Message message) {
        StringBuilder dataSb = new StringBuilder();
        dataSb.append("{\"header\":{");
        if (!StringUtils.isEmpty(message.getAppId())) {
            dataSb.append("\"appId\":\"").append(message.getAppId()).append("\",");
        }
        if (!StringUtils.isEmpty(message.getMsgApi())) {
            dataSb.append("\"msgApi\":\"").append(message.getMsgApi()).append("\",");
        }
        if (',' == dataSb.charAt(dataSb.length() - 1)) {
            dataSb.deleteCharAt(dataSb.length() - 1);
        }
        dataSb.append("}");
        if (!StringUtils.isEmpty(message.getBizContent())) {
            JSONValidator jsonValidator = new JSONValidator(new ExceptionErrorListener());
            if (!jsonValidator.validate(message.getBizContent())) {
                throw new IllegalArgumentException("bizContent json format illegal.");
            }
            dataSb.append(",\"content\":").append(message.getBizContent());
        }
        dataSb.append("}");
        String data = dataSb.toString();
        if ("{\"header\":{}}".equals(data)) {
            data = null;
        }
        return data;
    }

    public String getxType() {
        return this.xType;
    }

    public void setxType(String xType) {
        this.xType = xType;
    }

    public String getxCmd() {
        return this.xCmd;
    }

    public void setxCmd(String xCmd) {
        this.xCmd = xCmd;
    }

    public String getxMessageId() {
        return this.xMessageId;
    }

    public void setxMessageId(String xMessageId) {
        this.xMessageId = xMessageId;
    }

    public String getxStatus() {
        return this.xStatus;
    }

    public void setxStatus(String xStatus) {
        this.xStatus = xStatus;
    }

    public String getxCode() {
        return this.xCode;
    }

    public void setxCode(String xCode) {
        this.xCode = xCode;
    }

    public String getxError() {
        return this.xError;
    }

    public void setxError(String xError) {
        this.xError = xError;
    }

    public String getxSignType() {
        return this.xSignType;
    }

    public void setxSignType(String xSignType) {
        this.xSignType = xSignType;
    }

    public String getxSign() {
        return this.xSign;
    }

    public void setxSign(String xSign) {
        this.xSign = xSign;
    }

    public String getxCharset() {
        return this.xCharset;
    }

    public void setxCharset(String xCharset) {
        this.xCharset = xCharset;
    }

    public Long getxTimestamp() {
        return this.xTimestamp;
    }

    public void setxTimestamp(Long xTimestamp) {
        this.xTimestamp = xTimestamp;
    }

    public String getxVersion() {
        return this.xVersion;
    }

    public void setxVersion(String xVersion) {
        this.xVersion = xVersion;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMsgApi() {
        return this.msgApi;
    }

    public void setMsgApi(String msgApi) {
        this.msgApi = msgApi;
    }

    public String getBizContent() {
        return this.bizContent;
    }

    public void setBizContent(String bizContent) {
        this.bizContent = bizContent;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String toString() {
        return "Message{body='" + this.body + '\'' + '}';
    }
}

