/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.kms.aliyun.credentials;

import com.alipay.api.kms.aliyun.credentials.BasicSessionCredentials;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class EcsRamRoleCredentials
extends BasicSessionCredentials {
    private final Long expiration;
    private final Double expireFact = 0.95;
    private final Long refreshIntervalInMillSeconds = 180000L;
    private long lastFailedRefreshTime = 0L;

    public EcsRamRoleCredentials(String accessKeyId, String accessKeySecret, String sessionToken, String expiration, long roleSessionDurationSeconds) {
        super(accessKeyId, accessKeySecret, sessionToken, roleSessionDurationSeconds);
        SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        parser.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date date = parser.parse(expiration.replace('T', ' ').replace('Z', ' '));
            this.expiration = date.getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to get valid expiration time from ECS Metadata service.");
        }
    }

    public boolean willSoonExpire() {
        long now = System.currentTimeMillis();
        return (double)this.roleSessionDurationSeconds.longValue() * (1.0 - this.expireFact) > (double)((this.expiration - now) / 1000L);
    }

    public boolean isExpired() {
        long now = System.currentTimeMillis();
        return now >= this.expiration - this.refreshIntervalInMillSeconds;
    }

    public boolean shouldRefresh() {
        long now = System.currentTimeMillis();
        return now - this.lastFailedRefreshTime > this.refreshIntervalInMillSeconds;
    }

    public void setLastFailedRefreshTime() {
        this.lastFailedRefreshTime = System.currentTimeMillis();
    }
}

