/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.kms.aliyun;

import com.alipay.api.kms.aliyun.BackoffStrategy;

public class FullJitterBackoffStrategy
implements BackoffStrategy {
    private static final Integer DEFAULT_RETRY_MAX_ATTEMPTS = 3;
    private static final Long DEFAULT_RETRY_INITIAL_INTERVAL_MILLS = 2000L;
    private static final Long DEFAULT_CAPACITY = 10000L;
    private final Integer retryMaxAttempts;
    private final Long retryInitialIntervalMills;
    private final Long capacity;

    public FullJitterBackoffStrategy() {
        this.retryMaxAttempts = DEFAULT_RETRY_MAX_ATTEMPTS;
        this.retryInitialIntervalMills = DEFAULT_RETRY_INITIAL_INTERVAL_MILLS;
        this.capacity = DEFAULT_CAPACITY;
    }

    public FullJitterBackoffStrategy(Integer retryMaxAttempts, Long retryInitialIntervalMills, Long capacity) {
        this.retryMaxAttempts = retryMaxAttempts;
        this.retryInitialIntervalMills = retryInitialIntervalMills;
        this.capacity = capacity;
    }

    @Override
    public Long getWaitTimeExponential(int retryTimes) {
        if (retryTimes > this.retryMaxAttempts) {
            return -1L;
        }
        return Math.min(this.capacity, (long)(Math.pow(2.0, retryTimes) * (double)this.retryInitialIntervalMills.longValue()));
    }
}

