/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.kms.aliyun.http;

import com.alipay.api.kms.aliyun.exceptions.ClientException;
import com.alipay.api.kms.aliyun.http.CompositeX509TrustManager;
import com.alipay.api.kms.aliyun.http.FormatType;
import com.alipay.api.kms.aliyun.http.HttpRequest;
import com.alipay.api.kms.aliyun.http.HttpResponse;
import com.alipay.api.kms.aliyun.http.TrueHostnameVerifier;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class CompatibleUrlConnClient
implements Closeable {
    protected static final String ACCEPT_ENCODING = "Accept-Encoding";

    public static HttpResponse compatibleGetResponse(HttpRequest request) throws IOException, ClientException, NoSuchAlgorithmException {
        CompatibleUrlConnClient client = new CompatibleUrlConnClient();
        HttpResponse response = client.syncInvoke(request);
        client.close();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse syncInvoke(HttpRequest request) throws IOException, ClientException, NoSuchAlgorithmException {
        InputStream content = null;
        HttpURLConnection httpConn = this.buildHttpConnection(request);
        try {
            httpConn.connect();
            content = httpConn.getInputStream();
            HttpResponse response = new HttpResponse(httpConn.getURL().toString());
            this.parseHttpConn(response, httpConn, content);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (IOException e) {
            content = httpConn.getErrorStream();
            HttpResponse response = new HttpResponse(httpConn.getURL().toString());
            this.parseHttpConn(response, httpConn, content);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (content != null) {
                content.close();
            }
            httpConn.disconnect();
        }
    }

    public SSLSocketFactory createSSLSocketFactory() throws ClientException {
        try {
            CompositeX509TrustManager compositeX509TrustManager = new CompositeX509TrustManager();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{compositeX509TrustManager}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new ClientException("InitFailed", "Init https with SSL socket failed", e);
        }
    }

    public void checkHttpRequest(HttpRequest request) {
        String strUrl = request.getUrl();
        if (null == strUrl) {
            throw new IllegalArgumentException("URL is null for HttpRequest.");
        }
        if (null == request.getMethod()) {
            throw new IllegalArgumentException("Method is not set for HttpRequest.");
        }
    }

    public HttpURLConnection initHttpConnection(URL url, HttpRequest request) throws IOException, ClientException {
        HttpURLConnection httpConn;
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)url.openConnection();
            SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory();
            httpsConn.setSSLSocketFactory(sslSocketFactory);
            httpsConn.setHostnameVerifier(new TrueHostnameVerifier());
            httpConn = httpsConn;
        } else {
            httpConn = (HttpURLConnection)url.openConnection();
        }
        httpConn.setRequestMethod(request.getMethod().toString());
        httpConn.setInstanceFollowRedirects(false);
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setUseCaches(false);
        httpConn.setConnectTimeout(request.getConnectTimeout());
        httpConn.setReadTimeout(request.getReadTimeout());
        httpConn.setRequestProperty(ACCEPT_ENCODING, "identity");
        return httpConn;
    }

    public HttpURLConnection buildHttpConnection(HttpRequest request) throws IOException, ClientException {
        this.checkHttpRequest(request);
        String strUrl = request.getUrl();
        URL url = new URL(strUrl);
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        HttpURLConnection httpConn = this.initHttpConnection(url, request);
        return httpConn;
    }

    public void parseHttpConn(HttpResponse response, HttpURLConnection httpConn, InputStream content) throws IOException, NoSuchAlgorithmException {
        byte[] buff = this.readContent(content);
        response.setStatus(httpConn.getResponseCode());
        response.setResponseMessage(httpConn.getResponseMessage());
        Map<String, List<String>> headers = httpConn.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (null == key) continue;
            List<String> values = entry.getValue();
            StringBuilder builder = new StringBuilder(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                builder.append(",");
                builder.append(values.get(i));
            }
            response.putHeaderParameter(key, builder.toString());
        }
        String type = response.getHeaderValue("Content-Type");
        if (buff != null && type != null) {
            response.setEncoding("UTF-8");
            String[] split = type.split(";");
            response.setHttpContentType(FormatType.mapAcceptToFormat(split[0].trim()));
            if (split.length > 1 && split[1].contains("=")) {
                String[] codings = split[1].split("=");
                response.setEncoding(codings[1].trim().toUpperCase());
            }
        }
        response.setHttpContent(buff, response.getEncoding(), response.getHttpContentType());
    }

    private byte[] readContent(InputStream content) throws IOException {
        int read;
        if (content == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((read = content.read(buff)) != -1) {
            outputStream.write(buff, 0, read);
        }
        return outputStream.toByteArray();
    }

    @Override
    public void close() throws IOException {
    }
}

