/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.log;

import com.alipay.remoting.util.StringUtils;
import com.alipay.sofa.common.log.LoggerSpaceManager;
import java.io.File;
import org.slf4j.Logger;

public class BoltLoggerFactory {
    public static final String BOLT_LOG_SPACE_PROPERTY = "bolt.log.space";
    private static String BOLT_LOG_SPACE = "com.alipay.remoting";
    private static final String LOG_PATH = "logging.path";
    private static final String LOG_PATH_DEFAULT = System.getProperty("user.home") + File.separator + "logs";
    private static final String CLIENT_LOG_LEVEL = "com.alipay.remoting.client.log.level";
    private static final String CLIENT_LOG_LEVEL_DEFAULT = "INFO";
    private static final String CLIENT_LOG_ENCODE = "com.alipay.remoting.client.log.encode";
    private static final String CLIENT_LOG_ENCODE_DEFAULT = "UTF-8";

    public static Logger getLogger(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return BoltLoggerFactory.getLogger(clazz.getCanonicalName());
    }

    public static Logger getLogger(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Logger logger = LoggerSpaceManager.getLoggerBySpace((String)name, (String)BOLT_LOG_SPACE);
        return logger;
    }

    static {
        String logSpace = System.getProperty(BOLT_LOG_SPACE_PROPERTY);
        if (null != logSpace && !logSpace.isEmpty()) {
            BOLT_LOG_SPACE = logSpace;
        }
        String logPath = System.getProperty(LOG_PATH);
        String logLevel = System.getProperty(CLIENT_LOG_LEVEL);
        String logEncode = System.getProperty(CLIENT_LOG_ENCODE);
        if (StringUtils.isBlank(logPath)) {
            System.setProperty(LOG_PATH, LOG_PATH_DEFAULT);
        }
        if (StringUtils.isBlank(logLevel)) {
            System.setProperty(CLIENT_LOG_LEVEL, CLIENT_LOG_LEVEL_DEFAULT);
        }
        if (StringUtils.isBlank(logEncode)) {
            System.setProperty(CLIENT_LOG_ENCODE, CLIENT_LOG_ENCODE_DEFAULT);
        }
    }
}

