/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.CommandFactory;
import com.alipay.remoting.Connection;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.InvokeFuture;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.TimerHolder;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.RemotingUtil;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class BaseRemoting {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    protected CommandFactory commandFactory;

    public BaseRemoting(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    protected RemotingCommand invokeSync(final Connection conn, RemotingCommand request, int timeoutMillis) throws RemotingException, InterruptedException {
        final InvokeFuture future = this.createInvokeFuture(request, request.getInvokeContext());
        conn.addInvokeFuture(future);
        final int requestId = request.getId();
        try {
            conn.getChannel().writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (!f.isSuccess()) {
                        conn.removeInvokeFuture(requestId);
                        future.putResponse((RemotingCommand)BaseRemoting.this.commandFactory.createSendFailedResponse(conn.getRemoteAddress(), f.cause()));
                        logger.error("Invoke send failed, id={}", (Object)requestId, (Object)f.cause());
                    }
                }
            });
        }
        catch (Exception e) {
            conn.removeInvokeFuture(requestId);
            future.putResponse((RemotingCommand)this.commandFactory.createSendFailedResponse(conn.getRemoteAddress(), e));
            logger.error("Exception caught when sending invocation, id={}", (Object)requestId, (Object)e);
        }
        RemotingCommand response = future.waitResponse(timeoutMillis);
        if (response == null) {
            conn.removeInvokeFuture(requestId);
            response = this.commandFactory.createTimeoutResponse(conn.getRemoteAddress());
            logger.warn("Wait response, request id={} timeout!", (Object)requestId);
        }
        return response;
    }

    protected void invokeWithCallback(final Connection conn, RemotingCommand request, InvokeCallback invokeCallback, int timeoutMillis) {
        InvokeFuture future = this.createInvokeFuture(conn, request, request.getInvokeContext(), invokeCallback);
        conn.addInvokeFuture(future);
        final int requestId = request.getId();
        try {
            Timeout timeout = TimerHolder.getTimer().newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    InvokeFuture future = conn.removeInvokeFuture(requestId);
                    if (future != null) {
                        future.putResponse((RemotingCommand)BaseRemoting.this.commandFactory.createTimeoutResponse(conn.getRemoteAddress()));
                        future.tryAsyncExecuteInvokeCallbackAbnormally();
                    }
                }
            }, (long)timeoutMillis, TimeUnit.MILLISECONDS);
            future.addTimeout(timeout);
            conn.getChannel().writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture cf) throws Exception {
                    if (!cf.isSuccess()) {
                        InvokeFuture f = conn.removeInvokeFuture(requestId);
                        if (f != null) {
                            f.cancelTimeout();
                            f.putResponse((RemotingCommand)BaseRemoting.this.commandFactory.createSendFailedResponse(conn.getRemoteAddress(), cf.cause()));
                            f.tryAsyncExecuteInvokeCallbackAbnormally();
                        }
                        logger.error("Invoke send failed. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)cf.cause());
                    }
                }
            });
        }
        catch (Exception e) {
            InvokeFuture f = conn.removeInvokeFuture(requestId);
            if (f != null) {
                f.cancelTimeout();
                f.putResponse((RemotingCommand)this.commandFactory.createSendFailedResponse(conn.getRemoteAddress(), e));
                f.tryAsyncExecuteInvokeCallbackAbnormally();
            }
            logger.error("Exception caught when sending invocation. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)e);
        }
    }

    protected InvokeFuture invokeWithFuture(final Connection conn, RemotingCommand request, int timeoutMillis) {
        InvokeFuture future = this.createInvokeFuture(request, request.getInvokeContext());
        conn.addInvokeFuture(future);
        final int requestId = request.getId();
        try {
            Timeout timeout = TimerHolder.getTimer().newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    InvokeFuture future = conn.removeInvokeFuture(requestId);
                    if (future != null) {
                        future.putResponse((RemotingCommand)BaseRemoting.this.commandFactory.createTimeoutResponse(conn.getRemoteAddress()));
                    }
                }
            }, (long)timeoutMillis, TimeUnit.MILLISECONDS);
            future.addTimeout(timeout);
            conn.getChannel().writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture cf) throws Exception {
                    if (!cf.isSuccess()) {
                        InvokeFuture f = conn.removeInvokeFuture(requestId);
                        if (f != null) {
                            f.cancelTimeout();
                            f.putResponse((RemotingCommand)BaseRemoting.this.commandFactory.createSendFailedResponse(conn.getRemoteAddress(), cf.cause()));
                        }
                        logger.error("Invoke send failed. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)cf.cause());
                    }
                }
            });
        }
        catch (Exception e) {
            InvokeFuture f = conn.removeInvokeFuture(requestId);
            if (f != null) {
                f.cancelTimeout();
                f.putResponse((RemotingCommand)this.commandFactory.createSendFailedResponse(conn.getRemoteAddress(), e));
            }
            logger.error("Exception caught when sending invocation. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)e);
        }
        return future;
    }

    protected void oneway(final Connection conn, RemotingCommand request) {
        try {
            conn.getChannel().writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (!f.isSuccess()) {
                        logger.error("Invoke send failed. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)f.cause());
                    }
                }
            });
        }
        catch (Exception e) {
            if (null == conn) {
                logger.error("Conn is null");
            }
            logger.error("Exception caught when sending invocation. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)e);
        }
    }

    protected abstract InvokeFuture createInvokeFuture(RemotingCommand var1, InvokeContext var2);

    protected abstract InvokeFuture createInvokeFuture(Connection var1, RemotingCommand var2, InvokeContext var3, InvokeCallback var4);

    protected CommandFactory getCommandFactory() {
        return this.commandFactory;
    }
}

