/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionSelectStrategy;
import com.alipay.remoting.Scannable;
import com.alipay.remoting.log.BoltLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;

public class ConnectionPool
implements Scannable {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private CopyOnWriteArrayList<Connection> connections;
    private ConnectionSelectStrategy strategy;
    private volatile long lastAccessTimestamp;
    private volatile boolean asyncCreationDone;

    public ConnectionPool(ConnectionSelectStrategy strategy) {
        this.strategy = strategy;
        this.connections = new CopyOnWriteArrayList();
        this.asyncCreationDone = true;
    }

    public void add(Connection connection) {
        this.markAccess();
        if (null == connection) {
            return;
        }
        boolean res = this.connections.addIfAbsent(connection);
        if (res) {
            connection.increaseRef();
        }
    }

    public boolean contains(Connection connection) {
        return this.connections.contains(connection);
    }

    public void removeAndTryClose(Connection connection) {
        if (null == connection) {
            return;
        }
        boolean res = this.connections.remove(connection);
        if (res) {
            connection.decreaseRef();
        }
        if (connection.noRef()) {
            connection.close();
        }
    }

    public void removeAllAndTryClose() {
        for (Connection conn : this.connections) {
            this.removeAndTryClose(conn);
        }
        this.connections.clear();
    }

    public Connection get() {
        this.markAccess();
        if (null != this.connections) {
            ArrayList<Connection> snapshot = new ArrayList<Connection>(this.connections);
            if (snapshot.size() > 0) {
                return this.strategy.select(snapshot);
            }
            return null;
        }
        return null;
    }

    public List<Connection> getAll() {
        this.markAccess();
        return new ArrayList<Connection>(this.connections);
    }

    public int size() {
        return this.connections.size();
    }

    public boolean isEmpty() {
        return this.connections.isEmpty();
    }

    public long getLastAccessTimestamp() {
        return this.lastAccessTimestamp;
    }

    private void markAccess() {
        this.lastAccessTimestamp = System.currentTimeMillis();
    }

    public boolean isAsyncCreationDone() {
        return this.asyncCreationDone;
    }

    public void markAsyncCreationDone() {
        this.asyncCreationDone = true;
    }

    public void markAsyncCreationStart() {
        this.asyncCreationDone = false;
    }

    @Override
    public void scan() {
        if (null != this.connections && !this.connections.isEmpty()) {
            for (Connection conn : this.connections) {
                if (conn.isFine()) continue;
                logger.warn("Remove bad connection when scanning conns of ConnectionPool - {}:{}", (Object)conn.getRemoteIP(), (Object)conn.getRemotePort());
                conn.close();
                this.removeAndTryClose(conn);
            }
        }
    }
}

