/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc.protocol;

import com.alipay.remoting.CommandDecoder;
import com.alipay.remoting.ResponseStatus;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.HeartbeatAckCommand;
import com.alipay.remoting.rpc.HeartbeatCommand;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.protocol.RpcCommandCode;
import com.alipay.remoting.rpc.protocol.RpcProtocol;
import com.alipay.remoting.rpc.protocol.RpcRequestCommand;
import com.alipay.remoting.rpc.protocol.RpcResponseCommand;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;

public class RpcCommandDecoder
implements CommandDecoder {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");
    private int lessLen = RpcProtocol.getResponseHeaderLength() < RpcProtocol.getRequestHeaderLength() ? RpcProtocol.getResponseHeaderLength() : RpcProtocol.getRequestHeaderLength();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < this.lessLen) return;
        in.markReaderIndex();
        byte protocol = in.readByte();
        in.resetReaderIndex();
        if (protocol != 1) {
            String emsg = "Unknown protocol: " + protocol;
            logger.error(emsg);
            throw new RuntimeException(emsg);
        }
        if (in.readableBytes() <= 2) return;
        in.markReaderIndex();
        in.readByte();
        byte type = in.readByte();
        if (type == 1 || type == 2) {
            if (in.readableBytes() < RpcProtocol.getRequestHeaderLength() - 2) {
                in.resetReaderIndex();
                return;
            }
            short cmdCode = in.readShort();
            byte ver2 = in.readByte();
            int requestId = in.readInt();
            byte serializer = in.readByte();
            int timeout = in.readInt();
            short classLen = in.readShort();
            short headerLen = in.readShort();
            int contentLen = in.readInt();
            byte[] clazz = null;
            byte[] header = null;
            byte[] content = null;
            if (in.readableBytes() < classLen + headerLen + contentLen) {
                in.resetReaderIndex();
                return;
            }
            if (classLen > 0) {
                clazz = new byte[classLen];
                in.readBytes(clazz);
            }
            if (headerLen > 0) {
                header = new byte[headerLen];
                in.readBytes(header);
            }
            if (contentLen > 0) {
                content = new byte[contentLen];
                in.readBytes(content);
            }
            RequestCommand command = cmdCode == 0 ? new HeartbeatCommand() : this.createRequestCommand(cmdCode);
            command.setType(type);
            command.setVersion(ver2);
            command.setId(requestId);
            command.setSerializer(serializer);
            command.setTimeout(timeout);
            command.setClazz(clazz);
            command.setHeader(header);
            command.setContent(content);
            out.add(command);
            return;
        }
        if (type != 0) {
            String emsg = "Unknown command type: " + type;
            logger.error(emsg);
            throw new RuntimeException(emsg);
        }
        if (in.readableBytes() < RpcProtocol.getResponseHeaderLength() - 2) {
            in.resetReaderIndex();
            return;
        }
        short cmdCode = in.readShort();
        byte ver2 = in.readByte();
        int requestId = in.readInt();
        byte serializer = in.readByte();
        short status = in.readShort();
        short classLen = in.readShort();
        short headerLen = in.readShort();
        int contentLen = in.readInt();
        byte[] clazz = null;
        byte[] header = null;
        byte[] content = null;
        if (in.readableBytes() < classLen + headerLen + contentLen) {
            in.resetReaderIndex();
            return;
        }
        if (classLen > 0) {
            clazz = new byte[classLen];
            in.readBytes(clazz);
        }
        if (headerLen > 0) {
            header = new byte[headerLen];
            in.readBytes(header);
        }
        if (contentLen > 0) {
            content = new byte[contentLen];
            in.readBytes(content);
        }
        ResponseCommand command = cmdCode == 0 ? new HeartbeatAckCommand() : this.createResponseCommand(cmdCode);
        command.setType(type);
        command.setVersion(ver2);
        command.setId(requestId);
        command.setSerializer(serializer);
        command.setResponseStatus(ResponseStatus.valueOf(status));
        command.setClazz(clazz);
        command.setHeader(header);
        command.setContent(content);
        command.setResponseTimeMillis(System.currentTimeMillis());
        command.setResponseHost((InetSocketAddress)ctx.channel().remoteAddress());
        out.add(command);
    }

    private ResponseCommand createResponseCommand(short cmdCode) {
        RpcResponseCommand command = new RpcResponseCommand();
        command.setCmdCode(RpcCommandCode.valueOf(cmdCode));
        return command;
    }

    private RpcRequestCommand createRequestCommand(short cmdCode) {
        RpcRequestCommand command = new RpcRequestCommand();
        command.setCmdCode(RpcCommandCode.valueOf(cmdCode));
        command.setArriveTime(System.currentTimeMillis());
        return command;
    }
}

