/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.config.converter;

import com.alipay.sofa.common.config.Converter;
import com.alipay.sofa.common.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DefaultConverter
implements Converter {
    @Override
    public <T> T convert(String value, Class<T> targetType) {
        return (T)DefaultConverter.convertObjectFromString(targetType, value);
    }

    public static Object convertObjectFromString(Class<?> type, String value) {
        if (value == null) {
            return null;
        }
        if (type == null) {
            throw new NullPointerException("Type cannot be null");
        }
        if (StringUtil.isBlank(value) && type != String.class) {
            return null;
        }
        if (type == String.class) {
            return value;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return Short.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf(value.toCharArray()[0]);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Boolean.valueOf(value);
        }
        if (type == List.class) {
            return DefaultConverter.paresJson2ListMap(value);
        }
        throw new IllegalArgumentException("DefaultConverter not support type [" + type + "],failed to convert value [" + value + "].");
    }

    public static List<HashMap<Object, Object>> paresJson2ListMap(String s) {
        ArrayList<HashMap<Object, Object>> result = new ArrayList<HashMap<Object, Object>>();
        s = s.substring(1, s.length() - 1);
        while (s.contains("{")) {
            String[] entryStr;
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            String mapStr = s.substring(s.indexOf("{") + 1, s.indexOf("}"));
            for (String entry : entryStr = mapStr.split(",")) {
                String[] keyAndValue = (entry = entry.trim()).split("=");
                if (keyAndValue.length == 1) {
                    tmpMap.put(keyAndValue[0], "");
                }
                if (keyAndValue.length != 2) continue;
                tmpMap.put(keyAndValue[0], keyAndValue[1]);
            }
            result.add(tmpMap);
            s = s.substring(s.indexOf("}") + 1);
        }
        return result;
    }
}

