/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread;

import com.alipay.sofa.common.thread.ExecutingRunnable;
import com.alipay.sofa.common.thread.SofaThreadPoolExecutor;
import com.alipay.sofa.common.thread.log.ThreadLogger;
import com.alipay.sofa.common.utils.TimeWaitRunner;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TimeWaitRejectedExecutionHandler
implements RejectedExecutionHandler {
    private RejectedExecutionHandler delegate;
    private TimeWaitRunner timeWaitRunner;
    private SofaThreadPoolExecutor threadPoolExecutor;

    public TimeWaitRejectedExecutionHandler(SofaThreadPoolExecutor executor, long waitTime, TimeUnit timeUnit) {
        this.timeWaitRunner = new TimeWaitRunner(timeUnit.toMillis(waitTime));
        this.delegate = executor.getRejectedExecutionHandler();
        this.threadPoolExecutor = executor;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        this.timeWaitRunner.doWithRunnable(this::logStackTrace);
        this.getDelegate().rejectedExecution(r, executor);
    }

    private void logStackTrace() {
        if (this.threadPoolExecutor != null) {
            String threadPoolName = this.threadPoolExecutor.getConfig().getThreadPoolName();
            String allStackTrace = this.getAllStackTrace(this.threadPoolExecutor);
            ThreadLogger.error("Queue of thread pool {} is full with all stack trace: \n    {}\n\n", threadPoolName, allStackTrace);
        }
    }

    private String getAllStackTrace(SofaThreadPoolExecutor threadPoolExecutor) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ExecutingRunnable, Long> entry : threadPoolExecutor.getStatistics().getExecutingTasks().entrySet()) {
            for (StackTraceElement e : entry.getKey().thread.getStackTrace()) {
                sb.append("    ").append(e).append("\n");
            }
        }
        return sb.toString();
    }

    public RejectedExecutionHandler getDelegate() {
        return this.delegate;
    }

    public void setDelegate(RejectedExecutionHandler delegate) {
        this.delegate = delegate;
    }

    public void setTimeWaitRunner(TimeWaitRunner timeWaitRunner) {
        this.timeWaitRunner = timeWaitRunner;
    }

    public void setThreadPoolExecutor(SofaThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }
}

