/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread.space;

import com.alipay.sofa.common.thread.ThreadPoolGovernor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SpaceNamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final String namePrefix;
    private final boolean isDaemon;

    public SpaceNamedThreadFactory(String threadPoolName, String spaceName) {
        this(threadPoolName, spaceName, false);
    }

    public SpaceNamedThreadFactory(String threadPoolName, String spaceName, boolean daemon) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = spaceName + "-" + threadPoolName + "-" + ThreadPoolGovernor.getInstance().getSpaceNameThreadPoolNumber(spaceName) + "-thread-";
        this.isDaemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(this.isDaemon);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

