/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.utils;

import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharsetUtil {
    public static Logger CHARSET_MONITOR_LOG = LoggerFactory.getLogger((String)"CHARSET_MONITOR_LOG");
    public static final int MODE_ASSERT = 0;
    public static final int MODE_MONITOR = 1;

    public static void assertUTF8WellFormed(byte[] bytes) {
        CharsetUtil.checkUTF8WellFormed(bytes, 0);
    }

    public static void assertUTF8WellFormed(byte[] bytes, int off, int len) {
        CharsetUtil.checkUTF8WellFormed(bytes, off, len, 0);
    }

    public static void monitorUTF8WellFormed(byte[] bytes) {
        CharsetUtil.checkUTF8WellFormed(bytes, 1);
    }

    public static void monitorUTF8WellFormed(byte[] bytes, int off, int len) {
        CharsetUtil.checkUTF8WellFormed(bytes, off, len, 1);
    }

    public static void checkUTF8WellFormed(byte[] bytes, int mode) {
        CharsetUtil.checkUTF8WellFormed(bytes, 0, bytes.length, mode);
    }

    public static void checkUTF8WellFormed(byte[] bytes, int off, int len, int mode) {
        if (!CharsetUtil.isUTF8WellFormed(bytes, off, len)) {
            switch (mode) {
                case 0: {
                    throw new IllegalArgumentException("Input byte array is not well formed utf-8");
                }
                case 1: {
                    CHARSET_MONITOR_LOG.error("Detect not well formed utf-8 input: {}, trace:{}", (Object)new String(bytes, off, len, StandardCharsets.UTF_8), (Object)CharsetUtil.currentStackTrace());
                }
            }
        }
    }

    public static boolean isUTF8WellFormed(byte[] bytes) {
        return CharsetUtil.isUTF8WellFormed(bytes, 0, bytes.length);
    }

    public static boolean isUTF8WellFormed(byte[] bytes, int off, int len) {
        int end = off + len;
        if (off < 0 || end < off || end > bytes.length) {
            throw new IndexOutOfBoundsException("Illegal input arguments, start: " + off + ", end: " + end + ", size: " + bytes.length);
        }
        for (int i = off; i < end; ++i) {
            if (bytes[i] >= 0) continue;
            return CharsetUtil.isWellFormedSlowPath(bytes, i, end);
        }
        return true;
    }

    private static boolean isWellFormedSlowPath(byte[] bytes, int off, int end) {
        int index = off;
        while (true) {
            byte byte2;
            byte byte1;
            if (index >= end) {
                return true;
            }
            if ((byte1 = bytes[index++]) >= 0) continue;
            if (byte1 < -32) {
                if (index == end) {
                    return false;
                }
                if (byte1 >= -62 && bytes[index++] <= -65) continue;
                return false;
            }
            if (byte1 < -16) {
                if (index + 1 >= end) {
                    return false;
                }
                if (!((byte2 = bytes[index++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && -96 <= byte2) && bytes[index++] <= -65) continue;
                return false;
            }
            if (index + 2 >= end) {
                return false;
            }
            if ((byte2 = bytes[index++]) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || bytes[index++] > -65 || bytes[index++] > -65) break;
        }
        return false;
    }

    private static String currentStackTrace() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = 5; i < stackTraceElements.length; ++i) {
            sb.append("    ").append(stackTraceElements[i]).append("\n");
        }
        return sb.toString();
    }
}

