/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.core;

import com.alipay.sofa.healthcheck.core.HealthChecker;
import com.alipay.sofa.healthcheck.log.SofaBootHealthCheckLoggerFactory;
import com.alipay.sofa.healthcheck.utils.HealthCheckUtils;
import com.alipay.sofa.infra.utils.BinaryOperators;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class HealthCheckerProcessor {
    private static Logger logger = SofaBootHealthCheckLoggerFactory.getLogger(HealthCheckerProcessor.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private AtomicBoolean isInitiated = new AtomicBoolean(false);
    @Autowired
    private ApplicationContext applicationContext;
    private LinkedHashMap<String, HealthChecker> healthCheckers = null;

    public void init() {
        if (this.isInitiated.compareAndSet(false, true)) {
            Assert.notNull((Object)this.applicationContext, () -> "Application must not be null");
            Map beansOfType = this.applicationContext.getBeansOfType(HealthChecker.class);
            this.healthCheckers = HealthCheckUtils.sortMapAccordingToValue(beansOfType, (BeanFactory)this.applicationContext.getAutowireCapableBeanFactory());
            StringBuilder healthCheckInfo = new StringBuilder(512).append("Found ").append(this.healthCheckers.size()).append(" HealthChecker implementation:").append(String.join((CharSequence)",", this.healthCheckers.keySet()));
            logger.info(healthCheckInfo.toString());
        }
    }

    public boolean livenessHealthCheck(Map<String, Health> healthMap) {
        Assert.notNull(this.healthCheckers, () -> "HealthCheckers must not be null");
        logger.info("Begin SOFABoot HealthChecker liveness check.");
        boolean result = this.healthCheckers.entrySet().stream().map(entry -> this.doHealthCheck((String)entry.getKey(), (HealthChecker)entry.getValue(), false, healthMap, false)).reduce(true, BinaryOperators.andBoolean());
        if (result) {
            logger.info("SOFABoot HealthChecker liveness check result: success.");
        } else {
            logger.error("SOFABoot HealthChecker liveness check result: failed.");
        }
        return result;
    }

    public boolean readinessHealthCheck(Map<String, Health> healthMap) {
        Assert.notNull(this.healthCheckers, (String)"HealthCheckers must not be null.");
        logger.info("Begin SOFABoot HealthChecker readiness check.");
        boolean result = this.healthCheckers.entrySet().stream().map(entry -> this.doHealthCheck((String)entry.getKey(), (HealthChecker)entry.getValue(), true, healthMap, true)).reduce(true, BinaryOperators.andBoolean());
        if (result) {
            logger.info("SOFABoot HealthChecker readiness check result: success.");
        } else {
            logger.error("SOFABoot HealthChecker readiness check result: failed.");
        }
        return result;
    }

    private boolean doHealthCheck(String beanId, HealthChecker healthChecker, boolean isRetry, Map<String, Health> healthMap, boolean isReadiness) {
        Health health;
        boolean result;
        String checkType;
        Assert.notNull(healthMap, (String)"HealthMap must not be null");
        int retryCount = 0;
        String string = checkType = isReadiness ? "readiness" : "liveness";
        do {
            if (result = (health = healthChecker.isHealthy()).getStatus().equals((Object)Status.UP)) {
                logger.info("HealthChecker[{}] {} check success with {} retry.", new Object[]{beanId, checkType, retryCount});
                break;
            }
            logger.info("HealthChecker[{}] {} check fail with {} retry.", new Object[]{beanId, checkType, retryCount});
            if (!isRetry || retryCount >= healthChecker.getRetryCount()) continue;
            try {
                ++retryCount;
                TimeUnit.MILLISECONDS.sleep(healthChecker.getRetryTimeInterval());
            }
            catch (InterruptedException e) {
                logger.error(String.format("Exception occurred while sleeping of %d retry HealthChecker[%s] %s check.", retryCount, beanId, checkType), (Throwable)e);
            }
        } while (isRetry && retryCount < healthChecker.getRetryCount());
        healthMap.put(beanId, health);
        try {
            if (!result) {
                logger.error("HealthChecker[{}] {} check fail with {} retry; fail details:{}; strict mode:{}", new Object[]{beanId, checkType, retryCount, this.objectMapper.writeValueAsString((Object)health.getDetails()), healthChecker.isStrictCheck()});
            }
        }
        catch (JsonProcessingException ex) {
            logger.error(String.format("Error occurred while doing HealthChecker %s check.", checkType), (Throwable)ex);
        }
        return !healthChecker.isStrictCheck() || result;
    }
}

