/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.initializer;

import com.alipay.sofa.healthcheck.log.SofaBootHealthCheckLoggerFactory;
import com.alipay.sofa.infra.log.space.SofaBootLogSpaceIsolationInit;
import com.alipay.sofa.infra.utils.SOFABootEnvUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class SofaBootHealthCheckInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (SOFABootEnvUtils.isSpringCloudBootstrapEnvironment((Environment)environment)) {
            return;
        }
        String healthCheckLogLevelKey = "logging.level.com.alipay.sofa.healthcheck";
        SofaBootLogSpaceIsolationInit.initSofaBootLogger((Environment)environment, (String)healthCheckLogLevelKey);
        SofaBootHealthCheckLoggerFactory.getLogger(SofaBootHealthCheckInitializer.class).info("SOFABoot HealthCheck Starting!");
    }
}

