/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.service;

import com.alipay.sofa.healthcheck.startup.ReadinessCheckListener;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.util.CollectionUtils;

@Endpoint(id="readiness")
public class SofaBootReadinessCheckEndpoint {
    private final HealthAggregator healthAggregator = new OrderedHealthAggregator();
    @Autowired
    private ReadinessCheckListener readinessCheckListener;

    @ReadOperation
    public Health health() {
        boolean healthCheckerStatus = this.readinessCheckListener.getHealthCheckerStatus();
        Map<String, Health> healthCheckerDetails = this.readinessCheckListener.getHealthCheckerDetails();
        Map<String, Health> healthIndicatorDetails = this.readinessCheckListener.getHealthIndicatorDetails();
        boolean afterReadinessCheckCallbackStatus = this.readinessCheckListener.getHealthCallbackStatus();
        Map<String, Health> afterReadinessCheckCallbackDetails = this.readinessCheckListener.getHealthCallbackDetails();
        HashMap<String, Health> healths = new HashMap<String, Health>();
        Health.Builder builder = healthCheckerStatus && afterReadinessCheckCallbackStatus ? Health.up() : Health.down();
        if (!CollectionUtils.isEmpty(healthCheckerDetails)) {
            builder = builder.withDetail("HealthChecker", healthCheckerDetails);
        }
        if (!CollectionUtils.isEmpty(afterReadinessCheckCallbackDetails)) {
            builder = builder.withDetail("ReadinessCheckCallback", afterReadinessCheckCallbackDetails);
        }
        healths.put("SOFABootReadinessHealthCheckInfo", builder.build());
        healths.putAll(healthIndicatorDetails);
        return this.healthAggregator.aggregate(healths);
    }
}

