/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io.throwable;

import com.caucho.hessian.io.AbstractFieldAdaptorDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.HessianFieldException;
import com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThrowableDeserializer
extends AbstractFieldAdaptorDeserializer {
    private final Class<?> _type;
    protected Method addSuppressed = null;
    private final Throwable selfRef = new Throwable();

    public ThrowableDeserializer(Class cl) {
        super(cl);
        this._type = cl;
        try {
            this.addSuppressed = Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public Class getType() {
        return this._type;
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            int ref = in.addRef(this.selfRef);
            Map<String, Object> fieldValueMap = this.readField(in, fieldNames);
            Throwable obj = this.instantiate(this._type, fieldValueMap);
            this.fillFields(this._type, obj, fieldValueMap);
            in.setRef(ref, obj);
            return obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(Throwable.class.getName() + ":" + e, e);
        }
    }

    protected Map<String, Object> readField(AbstractHessianInput in, String[] fieldNames) throws IOException {
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
        for (int i = 0; i < fieldNames.length; ++i) {
            String name = fieldNames[i];
            Field field = (Field)this._fields.get(name);
            if (field == null) continue;
            if (String.class.equals(field.getType())) {
                fieldValueMap.put(name, in.readString());
                continue;
            }
            fieldValueMap.put(name, in.readObject());
        }
        return fieldValueMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Throwable instantiate(Class<?> clazz, Map<String, Object> fieldValueMap) throws Exception {
        Throwable ex = null;
        try {
            ex = this.doInstantiate(clazz, fieldValueMap);
        }
        catch (Exception exception) {
        }
        finally {
            if (ex == null) {
                ex = new Throwable((String)fieldValueMap.get("detailMessage"), (Throwable)fieldValueMap.get("cause"));
            }
        }
        return ex;
    }

    protected void fillFields(Class<?> clazz, Throwable obj, Map<String, Object> valueMap) throws IOException {
        for (String key : valueMap.keySet()) {
            Object value = valueMap.get(key);
            if (value == null) continue;
            if (key.equals("cause")) {
                if (value.equals(this.selfRef) || obj.getCause() != null) continue;
                try {
                    obj.initCause((Throwable)value);
                }
                catch (Exception e) {
                    this.logDeserializeError((Field)this._fields.get(key), value, e);
                }
                continue;
            }
            if (key.equals("suppressedExceptions")) {
                try {
                    List listValue;
                    if (!(value instanceof List) || (listValue = (List)value).size() == 0 || this.addSuppressed == null) continue;
                    for (Object item : listValue) {
                        this.addSuppressed.invoke((Object)obj, item);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (key.equals("stackTrace")) {
                obj.setStackTrace((StackTraceElement[])value);
                continue;
            }
            if (key.equals("detailMessage")) continue;
            this.fillOtherFields(clazz, obj, key, value);
        }
    }

    protected void fillOtherFields(Class<?> clazz, Throwable obj, String key, Object value) throws IOException {
        Field field = (Field)this._fields.get(key);
        if (field == null) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            this.logDeserializeError(field, value, e);
        }
    }

    private Throwable doInstantiate(Class<?> clazz, Map<String, Object> fieldValueMap) throws Exception {
        Constructor<?> causeConstructor = null;
        Constructor<?> messageConstructor = null;
        Constructor<?> defaultConstructor = null;
        Constructor<?> constructorByCost = null;
        long bestCost = Long.MAX_VALUE;
        for (Constructor<?> c : clazz.getDeclaredConstructors()) {
            Class<?>[] pTypes = c.getParameterTypes();
            if (pTypes.length == 0) {
                defaultConstructor = c;
                continue;
            }
            if (pTypes.length == 1 && pTypes[0].equals(String.class)) {
                messageConstructor = c;
                continue;
            }
            if (pTypes.length == 2 && pTypes[0].equals(String.class) && pTypes[1].equals(Throwable.class)) {
                causeConstructor = c;
                continue;
            }
            if (this.calculateCost(pTypes) >= bestCost) continue;
            constructorByCost = c;
        }
        String detailMessage = (String)fieldValueMap.get("detailMessage");
        Throwable cause = (Throwable)fieldValueMap.get("cause");
        if (causeConstructor != null) {
            return (Throwable)causeConstructor.newInstance(detailMessage, cause);
        }
        if (messageConstructor != null) {
            return (Throwable)messageConstructor.newInstance(detailMessage);
        }
        if (defaultConstructor != null) {
            return (Throwable)defaultConstructor.newInstance(new Object[0]);
        }
        if (constructorByCost != null) {
            Object[] args = this.getConstructorArgs(constructorByCost);
            return (Throwable)constructorByCost.newInstance(args);
        }
        return null;
    }

    protected Object[] getConstructorArgs(Constructor c) {
        Class<?>[] pTypes = c.getParameterTypes();
        Object[] constructorArgs = new Object[pTypes.length];
        for (int i = 0; i < pTypes.length; ++i) {
            constructorArgs[i] = this.getParamArg(pTypes[i]);
        }
        return constructorArgs;
    }

    protected long calculateCost(Class<?>[] pTypes) {
        long cost = 0L;
        for (int j = 0; j < pTypes.length; ++j) {
            cost = 4L * cost;
            if (Object.class.equals(pTypes[j])) {
                ++cost;
                continue;
            }
            if (String.class.equals(pTypes[j])) {
                cost += 2L;
                continue;
            }
            if (Integer.TYPE.equals(pTypes[j])) {
                cost += 3L;
                continue;
            }
            if (Long.TYPE.equals(pTypes[j])) {
                cost += 4L;
                continue;
            }
            if (pTypes[j].isPrimitive()) {
                cost += 5L;
                continue;
            }
            cost += 6L;
        }
        if (cost < 0L || cost > 65536L) {
            cost = 65536L;
        }
        return cost += (long)(pTypes.length << 48);
    }

    protected Object getParamArg(Class cl) {
        if (!cl.isPrimitive()) {
            return null;
        }
        if (Boolean.TYPE.equals(cl)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.equals(cl)) {
            return new Byte(0);
        }
        if (Short.TYPE.equals(cl)) {
            return new Short(0);
        }
        if (Character.TYPE.equals(cl)) {
            return new Character('\u0000');
        }
        if (Integer.TYPE.equals(cl)) {
            return 0;
        }
        if (Long.TYPE.equals(cl)) {
            return 0L;
        }
        if (Float.TYPE.equals(cl)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(cl)) {
            return 0.0;
        }
        throw new UnsupportedOperationException();
    }

    private void logDeserializeError(Field field, Object value, Throwable e) throws IOException {
        String fieldName = field.getDeclaringClass().getName() + "." + field.getName();
        if (e instanceof HessianFieldException) {
            throw (HessianFieldException)e;
        }
        if (e instanceof IOException) {
            throw new HessianFieldException(fieldName + ": " + e.getMessage(), e);
        }
        if (value != null) {
            throw new HessianFieldException(fieldName + ": " + value.getClass().getName() + " cannot be assigned to " + field.getType().getName());
        }
        throw new HessianFieldException(fieldName + ": " + field.getType().getName() + " cannot be assigned from null", e);
    }
}

