/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io.atomic;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.BasicDeserializer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class AtomicDeserializer
extends AbstractDeserializer {
    private Class<?> _type;
    private BasicDeserializer intArrayDsr = new BasicDeserializer(17);
    private BasicDeserializer longArrayDsr = new BasicDeserializer(18);

    public AtomicDeserializer(Class<?> cl) {
        this._type = cl;
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        if (AtomicInteger.class.equals(this._type)) {
            AtomicInteger tmp = new AtomicInteger();
            in.addRef(tmp);
            tmp.set(in.readInt());
            return tmp;
        }
        if (AtomicBoolean.class.equals(this._type)) {
            AtomicBoolean tmp = new AtomicBoolean();
            in.addRef(tmp);
            tmp.set(in.readInt() == 1);
            return tmp;
        }
        if (AtomicLong.class.equals(this._type)) {
            AtomicLong tmp = new AtomicLong();
            in.addRef(tmp);
            tmp.set(in.readLong());
            return tmp;
        }
        if (AtomicReference.class.equals(this._type)) {
            AtomicReference<Object> tmp = new AtomicReference<Object>();
            in.addRef(tmp);
            tmp.set(in.readObject());
            return tmp;
        }
        if (AtomicIntegerArray.class.equals(this._type)) {
            AtomicIntegerArray array = null;
            int ref = in.addRef(array);
            int[] res = (int[])this.intArrayDsr.readObject(in);
            int len = res.length;
            array = new AtomicIntegerArray(len);
            for (int i = 0; i < len; ++i) {
                array.set(i, res[i]);
            }
            in.setRef(ref, array);
            return array;
        }
        if (AtomicLongArray.class.equals(this._type)) {
            AtomicLongArray array = null;
            int ref = in.addRef(array);
            long[] res = (long[])this.longArrayDsr.readObject(in);
            int len = res.length;
            array = new AtomicLongArray(len);
            for (int i = 0; i < len; ++i) {
                array.set(i, res[i]);
            }
            in.setRef(ref, array);
            return array;
        }
        if (AtomicReferenceArray.class.equals(this._type)) {
            int ref = in.addRef(null);
            Object[] res = (Object[])in.readObject(new Object[0].getClass());
            int len = res.length;
            AtomicReferenceArray<Object> array = new AtomicReferenceArray<Object>(len);
            for (int i = 0; i < len; ++i) {
                array.set(i, res[i]);
            }
            in.setRef(ref, array);
            return array;
        }
        throw new UnsupportedOperationException(String.valueOf(this));
    }
}

