/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.JavaDeserializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractStringBuilderDeserializer
extends JavaDeserializer {
    private static final Logger log = Logger.getLogger(AbstractStringBuilderDeserializer.class.getName());
    private static final boolean ENABLE = AbstractStringBuilderDeserializer.judgeAvailability();
    private static Field stringValueField;
    private static Field stringCoderField;

    private static boolean judgeAvailability() {
        try {
            stringValueField = String.class.getDeclaredField("value");
            stringValueField.setAccessible(true);
        }
        catch (Throwable t) {
            return false;
        }
        return byte[].class.equals(stringValueField.getType());
    }

    public static boolean isEnable() {
        return ENABLE;
    }

    public AbstractStringBuilderDeserializer(Class<?> cl) {
        super(cl);
    }

    @Override
    protected HashMap getFieldMap(Class cl) {
        HashMap fieldMap = super.getFieldMap(cl);
        Field valueField = null;
        valueField = this.getAbstractStringBuilderField(cl, "value");
        if (valueField == null) {
            log.log(Level.WARNING, "get value field failed");
            return fieldMap;
        }
        Field coderField = null;
        if (fieldMap.containsKey("coder")) {
            coderField = this.getAbstractStringBuilderField(cl, "coder");
        }
        fieldMap.put("value", new StringBuilderValueFieldDeserializer(valueField, coderField));
        return fieldMap;
    }

    private Field getAbstractStringBuilderField(Class cl, String fieldName) {
        Field field = null;
        try {
            field = cl.getSuperclass().getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "get " + fieldName + " field failed", t);
            return null;
        }
        return field;
    }

    static {
        try {
            stringCoderField = String.class.getDeclaredField("coder");
            stringCoderField.setAccessible(true);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "coder field not found or not accessible, will skip coder check, error is " + t.getMessage());
        }
    }

    static class StringBuilderValueFieldDeserializer
    extends JavaDeserializer.FieldDeserializer {
        private final Field _field;
        private final Field _coderField;

        StringBuilderValueFieldDeserializer(Field value, Field coder) {
            this._field = value;
            this._coderField = coder;
        }

        @Override
        void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            block5: {
                Object value = null;
                try {
                    value = in.readObject();
                    if (value == null) {
                        return;
                    }
                    if (value instanceof String) {
                        this.dealWithStringValue((String)value, obj);
                        break block5;
                    }
                    if (value instanceof byte[]) {
                        this._field.set(obj, value);
                        break block5;
                    }
                    throw new UnsupportedEncodingException("\u672a\u77e5\u7684\u7f16\u7801\u7c7b\u578b" + value.getClass());
                }
                catch (Exception e) {
                    JavaDeserializer.logDeserializeError(this._field, obj, value, e);
                }
            }
        }

        public void dealWithStringValue(String value, Object obj) {
            try {
                byte[] res = (byte[])stringValueField.get(value);
                this._field.set(obj, res);
                if (stringCoderField != null) {
                    byte coder = stringCoderField.getByte(value);
                    this._coderField.set(obj, coder);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

