/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.infra.config.spring.namespace.handler;

import com.alipay.sofa.infra.config.spring.namespace.spi.SofaBootTagNameSupport;
import com.alipay.sofa.infra.log.InfraHealthCheckLoggerFactory;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class SofaBootNamespaceHandler
extends NamespaceHandlerSupport {
    private static final Logger logger = InfraHealthCheckLoggerFactory.getLogger(SofaBootNamespaceHandler.class);

    public void init() {
        ServiceLoader<SofaBootTagNameSupport> serviceLoaderSofaBoot = ServiceLoader.load(SofaBootTagNameSupport.class);
        for (SofaBootTagNameSupport tagNameSupport : serviceLoaderSofaBoot) {
            this.registerTagParser(tagNameSupport);
        }
    }

    private void registerTagParser(SofaBootTagNameSupport tagNameSupport) {
        if (tagNameSupport instanceof BeanDefinitionParser) {
            this.registerBeanDefinitionParser(tagNameSupport.supportTagName(), (BeanDefinitionParser)tagNameSupport);
        } else if (tagNameSupport instanceof BeanDefinitionDecorator) {
            this.registerBeanDefinitionDecoratorForAttribute(tagNameSupport.supportTagName(), (BeanDefinitionDecorator)tagNameSupport);
        } else {
            logger.error(tagNameSupport.getClass() + " tag name supported [" + tagNameSupport.supportTagName() + "] parser are not instance of " + BeanDefinitionParser.class + "or " + BeanDefinitionDecorator.class);
        }
    }
}

