/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.infra.endpoint;

import com.alipay.sofa.infra.log.InfraHealthCheckLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;

@ConfigurationProperties(prefix="com.alipay.sofa.versions")
public class SofaBootVersionEndpoint
extends AbstractEndpoint<Object> {
    public static final String SOFA_BOOT_VERSION_PREFIX = "sofaboot_versions";
    public static final String SOFA_BOOT_VERSION_PROPERTIES = "classpath*:META-INF/sofa.versions.properties";
    private Logger logger = InfraHealthCheckLoggerFactory.getLogger(SofaBootVersionEndpoint.class);
    private List<Object> endpointResult = null;
    private PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public SofaBootVersionEndpoint() {
        super(SOFA_BOOT_VERSION_PREFIX, false);
    }

    public Object invoke() {
        if (this.endpointResult != null) {
            return this.endpointResult;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            LinkedList<Properties> gavResult = new LinkedList<Properties>();
            this.generateGavResult(gavResult);
            if (gavResult.size() > 0) {
                result.addAll(gavResult);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Load properties failed  : " + ex.getMessage());
        }
        this.endpointResult = result;
        return this.endpointResult;
    }

    private void generateGavResult(List<Properties> gavResult) throws IOException {
        List<Resource> pomResourceLocations = this.getSofaVersionsPropertiesResources();
        if (pomResourceLocations == null || pomResourceLocations.size() <= 0) {
            return;
        }
        for (Resource sofaVersionsResource : pomResourceLocations) {
            Properties sofaVersionsProperties = this.loadProperties(sofaVersionsResource);
            gavResult.add(sofaVersionsProperties);
        }
    }

    private Properties loadProperties(Resource resourceLocation) {
        Properties result;
        block4: {
            result = new Properties();
            if (resourceLocation != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Loading properties file from " + resourceLocation);
                }
                try {
                    PropertiesLoaderUtils.fillProperties((Properties)result, (EncodedResource)new EncodedResource(resourceLocation));
                }
                catch (IOException ex) {
                    if (!this.logger.isWarnEnabled()) break block4;
                    this.logger.warn("Could not load properties from " + resourceLocation + ": " + ex.getMessage());
                }
            }
        }
        return result;
    }

    private List<Resource> getSofaVersionsPropertiesResources() throws IOException {
        List<String> paths = Collections.singletonList(SOFA_BOOT_VERSION_PROPERTIES);
        return this.getResources(paths);
    }

    private List<Resource> getResources(List<String> paths) throws IOException {
        if (paths == null || paths.size() == 0) {
            return null;
        }
        ArrayList<Resource> resultList = new ArrayList<Resource>();
        for (String path : paths) {
            Resource[] resources = this.resourcePatternResolver.getResources(path);
            List<Resource> resourceList = Arrays.asList(resources);
            resultList.addAll(resourceList);
        }
        return resultList;
    }
}

