/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.infra.utils;

import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public class SOFABootEnvUtils {
    private static final String SPRING_CLOUD_MARK_NAME = "org.springframework.cloud.bootstrap.BootstrapConfiguration";

    public static boolean isSpringCloudBootstrapEnvironment(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            return !((ConfigurableEnvironment)environment).getPropertySources().contains("sofaBootstrap") && SOFABootEnvUtils.isSpringCloud();
        }
        return false;
    }

    public static boolean isSpringCloud() {
        return ClassUtils.isPresent((String)SPRING_CLOUD_MARK_NAME, null);
    }
}

