/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle;

import com.alipay.sofa.isle.deployment.DeployRegistry;
import com.alipay.sofa.isle.deployment.DeploymentDescriptor;
import com.alipay.sofa.isle.deployment.ModuleDeploymentValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class ApplicationRuntimeModel {
    private final List<DeploymentDescriptor> deploys = new ArrayList<DeploymentDescriptor>();
    private final List<DeploymentDescriptor> inactiveDeploys = new ArrayList<DeploymentDescriptor>();
    private final List<DeploymentDescriptor> failed = new CopyOnWriteArrayList<DeploymentDescriptor>();
    private final List<DeploymentDescriptor> installed = new CopyOnWriteArrayList<DeploymentDescriptor>();
    private final Map<String, DeploymentDescriptor> springPowered = new LinkedHashMap<String, DeploymentDescriptor>();
    private final DeployRegistry deployRegistry = new DeployRegistry();
    private ModuleDeploymentValidator moduleDeploymentValidator;
    private String appName;
    private List<DeploymentDescriptor> resolvedDeployments;

    public void setModuleDeploymentValidator(ModuleDeploymentValidator moduleDeploymentValidator) {
        this.moduleDeploymentValidator = moduleDeploymentValidator;
    }

    public boolean isModuleDeployment(DeploymentDescriptor deploymentDescriptor) {
        return this.moduleDeploymentValidator.isModuleDeployment(deploymentDescriptor);
    }

    public void addDeployment(DeploymentDescriptor dd) {
        this.deploys.add(dd);
        this.deployRegistry.add(dd);
        this.springPowered.put(dd.getModuleName(), dd);
    }

    public List<DeploymentDescriptor> getAllDeployments() {
        Collections.sort(this.deploys);
        return this.deploys;
    }

    public void addInactiveDeployment(DeploymentDescriptor dd) {
        this.inactiveDeploys.add(dd);
    }

    public List<DeploymentDescriptor> getAllInactiveDeployments() {
        Collections.sort(this.inactiveDeploys);
        return this.inactiveDeploys;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public List<DeploymentDescriptor> getResolvedDeployments() {
        if (this.resolvedDeployments != null) {
            return this.resolvedDeployments;
        }
        this.resolvedDeployments = this.deployRegistry.getResolvedObjects();
        return this.resolvedDeployments;
    }

    public DeployRegistry getDeployRegistry() {
        return this.deployRegistry;
    }

    public DeploymentDescriptor getSpringPoweredDeployment(String springParent) {
        return this.springPowered.get(springParent);
    }

    public void addFailed(DeploymentDescriptor failed) {
        this.failed.add(failed);
    }

    public List<DeploymentDescriptor> getFailed() {
        return this.failed;
    }

    public void addInstalled(DeploymentDescriptor installed) {
        this.installed.add(installed);
    }

    public List<DeploymentDescriptor> getInstalled() {
        return this.installed;
    }
}

