/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class DependencyTree<K, T>
implements Iterable<Entry<K, T>> {
    private final Map<K, Entry<K, T>> registry = new HashMap<K, Entry<K, T>>();
    private final List<Entry<K, T>> resolved = new ArrayList<Entry<K, T>>();

    @Override
    public Iterator<Entry<K, T>> iterator() {
        return this.registry.values().iterator();
    }

    public void add(K key, T object, K ... requires) {
        this.add(key, object, (Collection<K>)Arrays.asList(requires));
    }

    public void add(K key, T object, Collection<K> requires) {
        Entry<K, T> entry = this.registry.get(key);
        if (entry == null) {
            entry = new Entry<K, T>(key, object);
            this.registry.put(key, entry);
        } else if (((Entry)entry).object == null) {
            ((Entry)entry).object = object;
        } else {
            return;
        }
        this.updateDependencies(entry, requires);
        if (entry.isResolved()) {
            this.resolve(entry);
        }
    }

    public void add(K key, T object) {
        this.add(key, object, (Collection)null);
    }

    public void remove(K key) {
        Entry<K, T> entry = this.registry.remove(key);
        if (entry != null) {
            this.unregister(entry);
        }
    }

    public void unregister(Entry<K, T> entry) {
        if (entry.isResolved()) {
            this.unresolve(entry);
        }
    }

    public Entry<K, T> getEntry(K key) {
        return this.registry.get(key);
    }

    public T get(K key) {
        Entry<K, T> entry = this.registry.get(key);
        return (T)(entry != null ? ((Entry)entry).object : null);
    }

    public void resolve(Entry<K, T> entry) {
        this.resolved.add(entry);
        Set<Entry<K, T>> dependencies = entry.getDependsOnMe();
        if (dependencies != null) {
            for (Entry<K, T> dep : dependencies) {
                dep.removeWaitingFor(entry);
                if (!dep.isResolved()) continue;
                this.resolve(dep);
            }
        }
    }

    public void unresolve(Entry<K, T> entry) {
        Set<Entry<K, T>> dependencies = entry.getDependsOnMe();
        if (dependencies != null) {
            for (Entry<K, T> dep : dependencies) {
                dep.addWaitingFor(entry);
                if (dep.isResolved()) continue;
                this.unresolve(dep);
            }
        }
        this.resolved.remove(entry);
    }

    public Collection<Entry<K, T>> getEntries() {
        return this.registry.values();
    }

    public List<Entry<K, T>> getPendingEntries() {
        ArrayList<Entry<K, T>> result = new ArrayList<Entry<K, T>>();
        for (Map.Entry<K, Entry<K, T>> entry : this.registry.entrySet()) {
            Entry<K, T> val = entry.getValue();
            if (val.isResolved()) continue;
            result.add(val);
        }
        return result;
    }

    public List<T> getPendingObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Entry<K, T>> entries = this.getPendingEntries();
        for (Entry<K, T> entry : entries) {
            list.add(((Entry)entry).object);
        }
        return list;
    }

    public List<Entry<K, T>> getMissingRequirements() {
        ArrayList<Entry<K, T>> result = new ArrayList<Entry<K, T>>();
        for (Map.Entry<K, Entry<K, T>> entry : this.registry.entrySet()) {
            Entry<K, T> val = entry.getValue();
            if (val.isRegistered()) continue;
            result.add(val);
        }
        return result;
    }

    public List<Entry<K, T>> getResolvedEntries() {
        return this.resolved;
    }

    public List<T> getResolvedObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Entry<K, T>> entries = this.getResolvedEntries();
        for (Entry<K, T> entry : entries) {
            list.add(((Entry)entry).object);
        }
        return list;
    }

    public void clear() {
        for (Entry<K, T> entry : this.resolved) {
            this.registry.remove(((Entry)entry).key);
        }
        this.resolved.clear();
        Iterator<Entry<K, T>> it = this.registry.values().iterator();
        while (it.hasNext()) {
            it.remove();
        }
    }

    protected void updateDependencies(Entry<K, T> entry, Collection<K> requires) {
        if (requires != null) {
            for (K req : requires) {
                Entry<K, Object> reqEntry = this.registry.get(req);
                if (reqEntry != null) {
                    if (reqEntry.isResolved()) {
                        reqEntry.addDependsOnMe(entry);
                        entry.addDependency(reqEntry);
                        continue;
                    }
                } else {
                    reqEntry = new Entry<K, Object>(req, null);
                    this.registry.put(req, reqEntry);
                }
                reqEntry.addDependsOnMe(entry);
                entry.addDependency(reqEntry);
                entry.addWaitingFor(reqEntry);
            }
        }
    }

    public static class Entry<K, T> {
        private final K key;
        private T object;
        private Set<Entry<K, T>> waitsFor;
        private Set<Entry<K, T>> dependsOnMe;
        private Set<Entry<K, T>> dependencies;

        public Entry(K key, T object) {
            this.key = key;
            this.object = object;
        }

        public final boolean isRegistered() {
            return this.object != null;
        }

        public final boolean isResolved() {
            return this.object != null && this.waitsFor == null;
        }

        public final void addWaitingFor(Entry<K, T> entry) {
            if (this.waitsFor == null) {
                this.waitsFor = new HashSet<Entry<K, T>>();
            }
            this.waitsFor.add(entry);
        }

        public final void removeWaitingFor(Entry<K, T> key) {
            if (this.waitsFor != null) {
                this.waitsFor.remove(key);
                if (this.waitsFor.isEmpty()) {
                    this.waitsFor = null;
                }
            }
        }

        public final void addDependsOnMe(Entry<K, T> entry) {
            if (this.dependsOnMe == null) {
                this.dependsOnMe = new HashSet<Entry<K, T>>();
            }
            this.dependsOnMe.add(entry);
        }

        public Set<Entry<K, T>> getDependsOnMe() {
            return this.dependsOnMe;
        }

        public void addDependency(Entry<K, T> entry) {
            if (this.dependencies == null) {
                this.dependencies = new CopyOnWriteArraySet<Entry<K, T>>();
            }
            this.dependencies.add(entry);
        }

        public Set<Entry<K, T>> getDependencies() {
            return this.dependencies;
        }

        public Set<Entry<K, T>> getWaitsFor() {
            return this.waitsFor;
        }

        public final T get() {
            return this.object;
        }

        public K getKey() {
            return this.key;
        }

        public String toString() {
            return this.key.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            return this.key.equals(((Entry)obj).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

