/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.deployment;

import com.alipay.sofa.isle.deployment.DependencyTree;
import com.alipay.sofa.isle.deployment.DeploymentDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DeployRegistry
extends DependencyTree<String, DeploymentDescriptor> {
    private final Map<String, DeploymentDescriptor> deployments = Collections.synchronizedSortedMap(new TreeMap());

    public void add(DeploymentDescriptor deployment) {
        this.deployments.put(deployment.getName(), deployment);
    }

    @Override
    public void remove(String key) {
        this.deployments.remove(key);
    }

    @Override
    public List<DependencyTree.Entry<String, DeploymentDescriptor>> getResolvedEntries() {
        if (!this.deployments.isEmpty()) {
            this.commitDeployments();
        }
        return super.getResolvedEntries();
    }

    @Override
    public List<DependencyTree.Entry<String, DeploymentDescriptor>> getMissingRequirements() {
        if (!this.deployments.isEmpty()) {
            this.commitDeployments();
        }
        return super.getMissingRequirements();
    }

    @Override
    public DeploymentDescriptor get(String key) {
        if (!this.deployments.isEmpty()) {
            this.commitDeployments();
        }
        return (DeploymentDescriptor)super.get(key);
    }

    @Override
    public Collection<DependencyTree.Entry<String, DeploymentDescriptor>> getEntries() {
        if (!this.deployments.isEmpty()) {
            this.commitDeployments();
        }
        return super.getEntries();
    }

    @Override
    public List<DeploymentDescriptor> getResolvedObjects() {
        if (!this.deployments.isEmpty()) {
            this.commitDeployments();
        }
        return super.getResolvedObjects();
    }

    @Override
    public List<DeploymentDescriptor> getPendingObjects() {
        if (!this.deployments.isEmpty()) {
            this.commitDeployments();
        }
        return super.getPendingObjects();
    }

    @Override
    public DependencyTree.Entry<String, DeploymentDescriptor> getEntry(String key) {
        if (!this.deployments.isEmpty()) {
            this.commitDeployments();
        }
        return super.getEntry(key);
    }

    @Override
    public List<DependencyTree.Entry<String, DeploymentDescriptor>> getPendingEntries() {
        if (!this.deployments.isEmpty()) {
            this.commitDeployments();
        }
        return super.getPendingEntries();
    }

    private void commitDeployments() {
        for (DeploymentDescriptor fd : this.deployments.values()) {
            this.add(fd.getModuleName(), fd, fd.getRequiredModules());
        }
        this.deployments.clear();
    }
}

