/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.deployment.impl;

import com.alipay.sofa.isle.deployment.DeploymentDescriptor;
import com.alipay.sofa.isle.deployment.DeploymentDescriptorConfiguration;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractDeploymentDescriptor
implements DeploymentDescriptor {
    final Properties properties;
    final DeploymentDescriptorConfiguration deploymentDescriptorConfiguration;
    private final ClassLoader classLoader;
    private final List<String> installedSpringXml = new ArrayList<String>();
    private ApplicationContext applicationContext;
    private long startTime;
    private long elapsedTime;
    final URL url;
    Map<String, Resource> springResources;

    public AbstractDeploymentDescriptor(URL url, Properties properties, DeploymentDescriptorConfiguration deploymentDescriptorConfiguration, ClassLoader classLoader) {
        this.url = url;
        this.properties = properties;
        this.deploymentDescriptorConfiguration = deploymentDescriptorConfiguration;
        this.classLoader = classLoader;
    }

    @Override
    public String getModuleName() {
        List<String> moduleNameIdentities = this.deploymentDescriptorConfiguration.getModuleNameIdentities();
        return Stream.of(moduleNameIdentities).filter(ele -> ele != null && ele.size() != 0).flatMap(Collection::stream).map(this.properties::get).filter(name -> StringUtils.hasText((String)((String)name))).findFirst().orElse(null);
    }

    @Override
    public String getName() {
        int jarIndex = this.url.toString().lastIndexOf(".jar");
        if (jarIndex == -1) {
            String moduleName = this.getModuleName();
            return moduleName == null ? "" : moduleName;
        }
        String jarPath = this.url.toString().substring(0, jarIndex + ".jar".length());
        int lastIndex = jarPath.lastIndexOf("/");
        return jarPath.substring(lastIndex + 1);
    }

    @Override
    public int compareTo(DeploymentDescriptor o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public List<String> getRequiredModules() {
        String requireModuleIdentity;
        List<String> requires = new ArrayList<String>();
        List<String> requireModuleIdentities = this.deploymentDescriptorConfiguration.getRequireModuleIdentities();
        if (requireModuleIdentities == null || requireModuleIdentities.size() == 0) {
            return requires;
        }
        Iterator<String> iterator = requireModuleIdentities.iterator();
        while (iterator.hasNext() && CollectionUtils.isEmpty(requires = this.getFormattedModuleInfo(requireModuleIdentity = iterator.next()))) {
        }
        String springParent = this.getSpringParent();
        if (springParent != null) {
            if (requires == null) {
                requires = new ArrayList(1);
            }
            requires.add(springParent);
        }
        return requires;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String getSpringParent() {
        List<String> name = this.getFormattedModuleInfo("Spring-Parent");
        return name == null ? null : name.get(0);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public Map<String, Resource> getSpringResources() {
        if (this.springResources == null) {
            this.loadSpringXMLs();
        }
        return this.springResources;
    }

    @Override
    public void addInstalledSpringXml(String fileName) {
        this.installedSpringXml.add(fileName);
    }

    @Override
    public boolean isSpringPowered() {
        if (this.springResources == null) {
            this.loadSpringXMLs();
        }
        return !this.springResources.isEmpty();
    }

    @Override
    public void startDeploy() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void deployFinish() {
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public List<String> getInstalledSpringXml() {
        Collections.sort(this.installedSpringXml);
        return this.installedSpringXml;
    }

    private List<String> getFormattedModuleInfo(String key) {
        String ret = this.properties.getProperty(key);
        if (ret == null || ret.length() == 0) {
            return null;
        }
        String[] array = ret.split(",");
        ArrayList<String> list = new ArrayList<String>(array.length);
        for (String item : array) {
            int idx = item.indexOf(59);
            if (idx > -1) {
                item = item.substring(0, idx);
            }
            list.add(item.trim());
        }
        return list;
    }

    protected abstract void loadSpringXMLs();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractDeploymentDescriptor)) {
            return false;
        }
        AbstractDeploymentDescriptor that = (AbstractDeploymentDescriptor)o;
        return Objects.equals(this.getModuleName(), that.getModuleName());
    }

    public int hashCode() {
        return Objects.hash(this.getModuleName());
    }
}

