/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.deployment.impl;

import com.alipay.sofa.isle.deployment.DeploymentDescriptorConfiguration;
import com.alipay.sofa.isle.deployment.impl.AbstractDeploymentDescriptor;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.springframework.core.io.FileSystemResource;

public class FileDeploymentDescriptor
extends AbstractDeploymentDescriptor {
    public FileDeploymentDescriptor(URL url, Properties props, DeploymentDescriptorConfiguration deploymentDescriptorConfiguration, ClassLoader classLoader) {
        super(url, props, deploymentDescriptorConfiguration, classLoader);
    }

    @Override
    public void loadSpringXMLs() {
        this.springResources = new HashMap();
        File springXml = new File(this.url.getFile().substring(0, this.url.getFile().length() - "sofa-module.properties".length()), "META-INF/spring");
        ArrayList<File> springFiles = new ArrayList<File>();
        if (springXml.exists()) {
            this.listFiles(springFiles, springXml, ".xml");
        }
        try {
            for (File f : springFiles) {
                this.springResources.put(f.getAbsolutePath(), new FileSystemResource(f));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void listFiles(List<File> subFiles, File parent, String suffix) {
        File[] files = parent.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File f : files) {
            if (f.isFile() && f.getName().endsWith(suffix)) {
                subFiles.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.listFiles(subFiles, f, suffix);
        }
    }
}

