/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.deployment.impl;

import com.alipay.sofa.isle.deployment.DeploymentDescriptorConfiguration;
import com.alipay.sofa.isle.deployment.impl.AbstractDeploymentDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public class JarDeploymentDescriptor
extends AbstractDeploymentDescriptor {
    public JarDeploymentDescriptor(URL url, Properties props, DeploymentDescriptorConfiguration deploymentDescriptorConfiguration, ClassLoader classLoader) {
        super(url, props, deploymentDescriptorConfiguration, classLoader);
    }

    @Override
    public void loadSpringXMLs() {
        this.springResources = new HashMap();
        try {
            URLConnection con = this.url.openConnection();
            Assert.isInstanceOf(JarURLConnection.class, (Object)con);
            JarURLConnection jarCon = (JarURLConnection)con;
            ResourceUtils.useCachesIfNecessary((URLConnection)jarCon);
            JarFile jarFile = jarCon.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith("META-INF/spring") || !entryPath.endsWith("xml")) continue;
                String fileName = entry.getName().substring("META-INF/spring".length() + 1);
                this.springResources.put(fileName, this.convertToByteArrayResource(jarFile.getInputStream(entry)));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private ByteArrayResource convertToByteArrayResource(InputStream inputStream) {
        try {
            int nRead;
            byte[] data = new byte[2048];
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return new ByteArrayResource(buffer.toByteArray());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

