/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.loader;

import com.alipay.sofa.isle.ApplicationRuntimeModel;
import com.alipay.sofa.isle.deployment.DeploymentDescriptor;
import com.alipay.sofa.isle.loader.SpringContextLoader;
import com.alipay.sofa.isle.spring.config.SofaModuleProperties;
import com.alipay.sofa.isle.spring.context.SofaModuleApplicationContext;
import com.alipay.sofa.isle.spring.factory.BeanLoadCostBeanFactory;
import com.alipay.sofa.runtime.spi.log.SofaLogger;
import com.alipay.sofa.runtime.spring.initializer.SofaRuntimeSpringContextInitializer;
import java.beans.PropertyEditor;
import java.util.Map;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.propertyeditors.ClassArrayEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class DynamicSpringContextLoader
implements SpringContextLoader {
    protected final ConfigurableApplicationContext rootApplicationContext;

    public DynamicSpringContextLoader(ApplicationContext applicationContext) {
        this.rootApplicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    @Override
    public void loadSpringContext(DeploymentDescriptor deployment, ApplicationRuntimeModel application) throws Exception {
        SofaModuleProperties sofaModuleProperties = (SofaModuleProperties)this.rootApplicationContext.getBean("sofaModuleProperties", SofaModuleProperties.class);
        BeanLoadCostBeanFactory beanFactory = new BeanLoadCostBeanFactory(sofaModuleProperties.getBeanLoadCost(), deployment.getModuleName());
        beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new QualifierAnnotationAutowireCandidateResolver());
        GenericApplicationContext ctx = sofaModuleProperties.isPublishEventToParent() ? new GenericApplicationContext((DefaultListableBeanFactory)beanFactory) : new SofaModuleApplicationContext(beanFactory);
        SofaRuntimeSpringContextInitializer.initApplicationContext((ConfigurableApplicationContext)ctx);
        String activeProfiles = sofaModuleProperties.getActiveProfiles();
        if (StringUtils.hasText((String)activeProfiles)) {
            String[] profiles = activeProfiles.split(",");
            ctx.getEnvironment().setActiveProfiles(profiles);
        }
        this.setUpParentSpringContext(ctx, deployment, application);
        final ClassLoader moduleClassLoader = deployment.getClassLoader();
        ctx.setClassLoader(moduleClassLoader);
        CachedIntrospectionResults.acceptClassLoader((ClassLoader)moduleClassLoader);
        ctx.setAllowBeanDefinitionOverriding(sofaModuleProperties.isAllowBeanDefinitionOverriding());
        ctx.getBeanFactory().setBeanClassLoader(moduleClassLoader);
        ctx.getBeanFactory().addPropertyEditorRegistrar(new PropertyEditorRegistrar(){

            public void registerCustomEditors(PropertyEditorRegistry registry) {
                registry.registerCustomEditor(Class.class, (PropertyEditor)new ClassEditor(moduleClassLoader));
                registry.registerCustomEditor(Class[].class, (PropertyEditor)new ClassArrayEditor(moduleClassLoader));
            }
        });
        deployment.setApplicationContext((ApplicationContext)ctx);
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        beanDefinitionReader.setValidating(true);
        beanDefinitionReader.setNamespaceAware(true);
        beanDefinitionReader.setBeanClassLoader(deployment.getApplicationContext().getClassLoader());
        beanDefinitionReader.setResourceLoader((ResourceLoader)ctx);
        this.loadBeanDefinitions(deployment, beanDefinitionReader);
        this.addPostProcessors(beanFactory);
    }

    protected void loadBeanDefinitions(DeploymentDescriptor deployment, XmlBeanDefinitionReader beanDefinitionReader) {
        for (Map.Entry<String, Resource> entry : deployment.getSpringResources().entrySet()) {
            String fileName = entry.getKey();
            beanDefinitionReader.loadBeanDefinitions(entry.getValue());
            deployment.addInstalledSpringXml(fileName);
        }
    }

    private void setUpParentSpringContext(GenericApplicationContext applicationContext, DeploymentDescriptor deployment, ApplicationRuntimeModel application) {
        ConfigurableApplicationContext parentSpringContext = this.getSpringParent(deployment, application);
        if (parentSpringContext != null) {
            applicationContext.setParent((ApplicationContext)parentSpringContext);
        } else {
            applicationContext.setParent((ApplicationContext)this.rootApplicationContext);
        }
    }

    private ConfigurableApplicationContext getSpringParent(DeploymentDescriptor deployment, ApplicationRuntimeModel application) {
        DeploymentDescriptor parent;
        String springParent;
        ConfigurableApplicationContext parentSpringContext = null;
        if (deployment.getSpringParent() != null && StringUtils.hasText((String)(springParent = deployment.getSpringParent())) && (parent = application.getSpringPoweredDeployment(springParent)) != null && (parentSpringContext = (ConfigurableApplicationContext)parent.getApplicationContext()) == null) {
            SofaLogger.warn((String)"Module [{0}]'s Spring-Parent [{1}] is Null!", (Object[])new Object[]{deployment.getModuleName(), springParent});
        }
        return parentSpringContext;
    }

    private void addPostProcessors(DefaultListableBeanFactory beanFactory) {
        Map processors = (Map)this.rootApplicationContext.getBean("PROCESSORS_OF_ROOT_APPLICATION_CONTEXT");
        for (Map.Entry entry : processors.entrySet()) {
            if (beanFactory.containsBeanDefinition((String)entry.getKey())) continue;
            beanFactory.registerBeanDefinition((String)entry.getKey(), (BeanDefinition)entry.getValue());
        }
    }
}

