/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.profile;

import com.alipay.sofa.isle.profile.SofaModuleProfileEnvironment;
import com.alipay.sofa.isle.spring.config.SofaModuleProperties;
import java.util.HashSet;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultSofaModuleProfileEnvironment
implements SofaModuleProfileEnvironment {
    private final Set<String> activeProfiles = new HashSet<String>();

    @Override
    public void initEnvironment(ApplicationContext applicationContext) {
        this.activeProfiles.clear();
        this.activeProfiles.add("default");
        if (applicationContext == null || applicationContext.getEnvironment() == null) {
            return;
        }
        String activeProfiles = ((SofaModuleProperties)applicationContext.getBean("sofaModuleProperties", SofaModuleProperties.class)).getActiveProfiles();
        if (StringUtils.hasText((String)activeProfiles)) {
            String[] activeConfigProfileList = activeProfiles.split(",");
            this.initActiveProfiles(activeConfigProfileList);
        }
    }

    @Override
    public boolean acceptsProfiles(String[] sofaModuleProfiles) {
        Assert.notEmpty((Object[])sofaModuleProfiles, (String)"Must specify at least one sofa module profile,at least one profile value is default");
        for (String sofaModuleProfile : sofaModuleProfiles) {
            if (!(StringUtils.hasText((String)sofaModuleProfile) && sofaModuleProfile.charAt(0) == '!' ? !this.isProfileActive(sofaModuleProfile.substring(1)) : this.isProfileActive(sofaModuleProfile))) continue;
            return true;
        }
        return false;
    }

    private void initActiveProfiles(String[] ActiveProfiles) {
        if (ActiveProfiles == null || ActiveProfiles.length == 0) {
            return;
        }
        for (String sofaProfile : ActiveProfiles) {
            this.validateProfile(sofaProfile);
            this.activeProfiles.add(sofaProfile.trim());
        }
    }

    private boolean isProfileActive(String moduleProfile) {
        this.validateProfile(moduleProfile);
        return this.activeProfiles.contains(moduleProfile.trim());
    }

    private void validateProfile(String profile) {
        if (!StringUtils.hasText((String)profile)) {
            throw new IllegalArgumentException("Invalid profile [" + profile + "]: must contain text and at least a value " + "default");
        }
        if (profile.charAt(0) == '!') {
            throw new IllegalArgumentException("Invalid sofa.profiles.active value in sofa-config.config [" + profile + "]: must not begin with ! operator");
        }
    }
}

