/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.spring.context;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class SofaModuleApplicationContext
extends GenericApplicationContext {
    private static final Method getApplicationEventMulticasterMethod;
    private static final Field earlyApplicationEventsField;

    public SofaModuleApplicationContext(DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    protected void publishEvent(Object event, ResolvableType eventType) {
        ApplicationEvent applicationEvent;
        Assert.notNull((Object)event, (String)"Event must not be null");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Publishing event in " + this.getDisplayName() + ": " + event));
        }
        if (event instanceof ApplicationEvent) {
            applicationEvent = (ApplicationEvent)event;
        } else {
            applicationEvent = new PayloadApplicationEvent((Object)this, event);
            if (eventType == null) {
                eventType = ((PayloadApplicationEvent)applicationEvent).getResolvableType();
            }
        }
        Set earlyApplicationEvents = (Set)this.getFieldValueByReflect(earlyApplicationEventsField, (Object)this);
        if (earlyApplicationEvents != null) {
            earlyApplicationEvents.add(applicationEvent);
        } else {
            ApplicationEventMulticaster applicationEventMulticaster = (ApplicationEventMulticaster)this.getMethodValueByReflect(getApplicationEventMulticasterMethod, (Object)this, new Object[0]);
            applicationEventMulticaster.multicastEvent(applicationEvent, eventType);
        }
    }

    private <T> T getFieldValueByReflect(Field field, Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T getMethodValueByReflect(Method method, Object obj, Object ... args) {
        try {
            return (T)method.invoke(obj, args);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            getApplicationEventMulticasterMethod = AbstractApplicationContext.class.getDeclaredMethod("getApplicationEventMulticaster", new Class[0]);
            getApplicationEventMulticasterMethod.setAccessible(true);
            earlyApplicationEventsField = AbstractApplicationContext.class.getDeclaredField("earlyApplicationEvents");
            earlyApplicationEventsField.setAccessible(true);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

