/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.spring.factory;

import com.alipay.sofa.runtime.spring.factory.ServiceFactoryBean;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class BeanLoadCostBeanFactory
extends DefaultListableBeanFactory {
    private static final long DEFAULT_BEAN_LOAD_COST = 100L;
    private final List<BeanNode> beanCostList = new ArrayList<BeanNode>();
    private long beanLoadCost = 100L;
    private String moduleName;

    public BeanLoadCostBeanFactory(long beanCost, String moduleName) {
        this.beanLoadCost = beanCost;
        this.moduleName = moduleName;
    }

    protected Object createBean(String beanName, RootBeanDefinition mbd, Object[] args) throws BeanCreationException {
        long begin = System.currentTimeMillis();
        Object object = super.createBean(beanName, mbd, args);
        BeanNode beanNameNode = new BeanNode();
        if (mbd.getBeanClassName() == null) {
            beanNameNode.beanClassName = "Factory (" + mbd.getFactoryBeanName() + ")";
        } else if (object instanceof ServiceFactoryBean) {
            beanNameNode.beanClassName = mbd.getBeanClassName() + " (" + ((ServiceFactoryBean)object).getBeanId() + ")";
        } else {
            beanNameNode.beanClassName = mbd.getBeanClassName() + " (" + beanName + ")";
            if (beanName.contains(mbd.getBeanClassName())) {
                beanNameNode.beanClassName = mbd.getBeanClassName();
            }
        }
        beanNameNode.costTime = System.currentTimeMillis() - begin;
        if (beanNameNode.costTime >= this.beanLoadCost) {
            this.beanCostList.add(beanNameNode);
        }
        return object;
    }

    public List<BeanNode> getBeanLoadList() {
        return this.beanCostList;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public class BeanNode {
        public String beanClassName;
        public long costTime;

        public String toString() {
            return this.beanClassName + "\t[" + this.costTime + " ms]";
        }
    }
}

