/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.spring.health;

import com.alipay.sofa.isle.ApplicationRuntimeModel;
import com.alipay.sofa.isle.deployment.DeploymentDescriptor;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractModuleHealthChecker
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public Health doHealthCheck() {
        Health.Builder builder = new Health.Builder();
        ApplicationRuntimeModel application = (ApplicationRuntimeModel)this.applicationContext.getBean("SOFABOOT-APPLICATION", ApplicationRuntimeModel.class);
        for (DeploymentDescriptor deploymentDescriptor : application.getInstalled()) {
            builder.withDetail(deploymentDescriptor.getName(), (Object)"passed");
        }
        for (DeploymentDescriptor deploymentDescriptor : application.getAllInactiveDeployments()) {
            builder.withDetail(deploymentDescriptor.getName(), (Object)"inactive");
        }
        for (DeploymentDescriptor deploymentDescriptor : application.getFailed()) {
            builder.withDetail(deploymentDescriptor.getName(), (Object)"failed");
        }
        if (application.getFailed().size() == 0) {
            return builder.status(Status.UP).build();
        }
        return builder.status(Status.DOWN).build();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

