/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.spring.listener;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;

public class SofaModuleBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private final String[] whiteNameList = new String[]{ConfigurationClassPostProcessor.class.getName() + ".importAwareProcessor", ConfigurationClassPostProcessor.class.getName() + ".importRegistry", ConfigurationClassPostProcessor.class.getName() + ".enhancedConfigurationProcessor"};

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Map<String, BeanDefinition> postProcessorDefinitions = this.getBeanDefinitionsForType(beanFactory, BeanPostProcessor.class, BeanFactoryPostProcessor.class);
        beanFactory.registerSingleton("PROCESSORS_OF_ROOT_APPLICATION_CONTEXT", postProcessorDefinitions);
    }

    private Map<String, BeanDefinition> getBeanDefinitionsForType(ConfigurableListableBeanFactory beanFactory, Class ... types) {
        HashMap<String, BeanDefinition> map = new HashMap<String, BeanDefinition>();
        for (Class type : types) {
            String[] beanNamesForType = beanFactory.getBeanNamesForType(type);
            List<String> beanDefinitionNames = Arrays.asList(beanFactory.getBeanDefinitionNames());
            for (String beanName : beanNamesForType) {
                if (!this.notInWhiteNameList(beanName) || !beanDefinitionNames.contains(beanName)) continue;
                map.put(beanName, beanFactory.getBeanDefinition(beanName));
            }
        }
        return map;
    }

    private boolean notInWhiteNameList(String beanName) {
        for (String whiteName : this.whiteNameList) {
            if (!whiteName.equals(beanName)) continue;
            return false;
        }
        return true;
    }
}

