/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.spring.listener;

import com.alipay.sofa.isle.stage.DefaultPipelineContext;
import com.alipay.sofa.isle.stage.PipelineStage;
import com.alipay.sofa.runtime.spi.log.SofaLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.OrderComparator;
import org.springframework.core.PriorityOrdered;

public class SofaModuleContextRefreshedListener
implements PriorityOrdered,
ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.applicationContext.equals(event.getApplicationContext())) {
            DefaultPipelineContext pipelineContext = new DefaultPipelineContext();
            pipelineContext.appendStages(this.getPipelineStagesInApplicationContext(event.getApplicationContext()));
            try {
                pipelineContext.process();
            }
            catch (Throwable t) {
                SofaLogger.error((Throwable)t, (String)"process pipeline error", (Object[])new Object[0]);
                throw new RuntimeException(t);
            }
        }
    }

    private List<PipelineStage> getPipelineStagesInApplicationContext(ApplicationContext applicationContext) {
        Map beanName2PipelineStage = applicationContext.getBeansOfType(PipelineStage.class);
        HashMap pipelineName2PipelineStage = new HashMap();
        for (Map.Entry beanName2PipelineStageEntry : beanName2PipelineStage.entrySet()) {
            String pipelineName = ((PipelineStage)beanName2PipelineStageEntry.getValue()).getName();
            PipelineStage oldValue = (PipelineStage)pipelineName2PipelineStage.get(pipelineName);
            if (oldValue != null && oldValue.getPriority() >= ((PipelineStage)beanName2PipelineStageEntry.getValue()).getPriority()) continue;
            pipelineName2PipelineStage.put(pipelineName, beanName2PipelineStageEntry.getValue());
        }
        ArrayList<PipelineStage> pipelineStages = new ArrayList<PipelineStage>(pipelineName2PipelineStage.values());
        OrderComparator.sort(pipelineStages);
        return pipelineStages;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

