/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.stage;

import com.alipay.sofa.isle.ApplicationRuntimeModel;
import com.alipay.sofa.isle.deployment.DeploymentBuilder;
import com.alipay.sofa.isle.deployment.DeploymentDescriptor;
import com.alipay.sofa.isle.deployment.DeploymentDescriptorConfiguration;
import com.alipay.sofa.isle.deployment.impl.DefaultModuleDeploymentValidator;
import com.alipay.sofa.isle.stage.AbstractPipelineStage;
import com.alipay.sofa.isle.utils.SofaModuleProfileUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.UrlResource;

public class ModelCreatingStage
extends AbstractPipelineStage {
    public ModelCreatingStage(AbstractApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    protected void doProcess() throws Exception {
        ApplicationRuntimeModel application = new ApplicationRuntimeModel();
        application.setAppName(this.appName);
        application.setModuleDeploymentValidator(new DefaultModuleDeploymentValidator());
        this.getAllDeployments(application);
        this.applicationContext.getBeanFactory().registerSingleton("SOFABOOT-APPLICATION", (Object)application);
    }

    private void getAllDeployments(ApplicationRuntimeModel application) throws IOException {
        Enumeration<URL> urls = this.appClassLoader.getResources("sofa-module.properties");
        if (urls == null || !urls.hasMoreElements()) {
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            UrlResource urlResource = new UrlResource(url);
            Properties props = new Properties();
            props.load(urlResource.getInputStream());
            DeploymentDescriptorConfiguration deploymentDescriptorConfiguration = new DeploymentDescriptorConfiguration(Collections.singletonList("Module-Name"), Collections.singletonList("Require-Module"));
            DeploymentDescriptor dd = DeploymentBuilder.build(url, props, deploymentDescriptorConfiguration, this.appClassLoader);
            if (!application.isModuleDeployment(dd)) continue;
            if (SofaModuleProfileUtil.acceptProfile((ApplicationContext)this.applicationContext, dd)) {
                application.addDeployment(dd);
                continue;
            }
            application.addInactiveDeployment(dd);
        }
    }

    @Override
    public String getName() {
        return "ModelCreatingStage";
    }

    public int getOrder() {
        return 10000;
    }
}

