/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.stage;

import com.alipay.sofa.isle.ApplicationRuntimeModel;
import com.alipay.sofa.isle.deployment.DeploymentDescriptor;
import com.alipay.sofa.isle.spring.factory.BeanLoadCostBeanFactory;
import com.alipay.sofa.isle.stage.AbstractPipelineStage;
import com.alipay.sofa.runtime.spi.log.SofaLogger;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.util.CollectionUtils;

public class ModuleLogOutputStage
extends AbstractPipelineStage {
    private static final String SYMBOLIC1 = "  \u251c\u2500 ";
    private static final String SYMBOLIC2 = "  \u2514\u2500 ";
    private static final String SYMBOLIC3 = "  \u2502    +---";
    private static final String SYMBOLIC4 = "  \u2502    `---";
    private static final String SYMBOLIC5 = "       +---";
    private static final String SYMBOLIC6 = "       `---";

    public ModuleLogOutputStage(AbstractApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    protected void doProcess() throws Exception {
        ApplicationRuntimeModel application = (ApplicationRuntimeModel)this.applicationContext.getBean("SOFABOOT-APPLICATION", ApplicationRuntimeModel.class);
        StringBuilder stringBuilder = new StringBuilder();
        this.logInstalledModules(stringBuilder, application.getInstalled());
        this.logFailedModules(stringBuilder, application.getFailed());
        this.logInfoBeanCost(stringBuilder, application.getInstalled());
        SofaLogger.info((String)stringBuilder.toString(), (Object[])new Object[0]);
    }

    private void logInstalledModules(StringBuilder stringBuilder, List<DeploymentDescriptor> deploys) {
        long totalTime = 0L;
        long realStart = 0L;
        long realEnd = 0L;
        stringBuilder.append("\n").append("Spring context initialize success module list").append("(").append(deploys.size()).append(") >>>>>>>");
        StringBuilder sb = new StringBuilder();
        Iterator<DeploymentDescriptor> i = deploys.iterator();
        while (i.hasNext()) {
            DeploymentDescriptor dd = i.next();
            String outTreeSymbol = SYMBOLIC1;
            String innerTreeSymbol1 = SYMBOLIC3;
            String innerTreeSymbol2 = SYMBOLIC4;
            if (!i.hasNext()) {
                outTreeSymbol = SYMBOLIC2;
                innerTreeSymbol1 = SYMBOLIC5;
                innerTreeSymbol2 = SYMBOLIC6;
            }
            sb.append(outTreeSymbol).append(dd.getName()).append(" [").append(dd.getElapsedTime()).append(" ms]\n");
            totalTime += dd.getElapsedTime();
            Iterator<String> j = dd.getInstalledSpringXml().iterator();
            while (j.hasNext()) {
                String xmlPath = j.next();
                String innerTreeSymbol = innerTreeSymbol1;
                if (!j.hasNext()) {
                    innerTreeSymbol = innerTreeSymbol2;
                }
                sb.append(innerTreeSymbol).append(xmlPath).append("\n");
            }
            if (realStart == 0L || dd.getStartTime() < realStart) {
                realStart = dd.getStartTime();
            }
            if (realEnd != 0L && dd.getStartTime() + dd.getElapsedTime() <= realEnd) continue;
            realEnd = dd.getStartTime() + dd.getElapsedTime();
        }
        stringBuilder.append(" [totalTime = ").append(totalTime).append(" ms, realTime = ").append(realEnd - realStart).append(" ms]\n").append((CharSequence)sb);
    }

    private void logFailedModules(StringBuilder stringBuilder, List<DeploymentDescriptor> deploys) {
        stringBuilder.append("\n").append("Spring context initialize failed module list").append("(").append(deploys.size()).append(") >>>>>>>\n");
        Iterator<DeploymentDescriptor> i = deploys.iterator();
        while (i.hasNext()) {
            DeploymentDescriptor dd = i.next();
            String treeSymbol = SYMBOLIC1;
            if (!i.hasNext()) {
                treeSymbol = SYMBOLIC2;
            }
            stringBuilder.append(treeSymbol).append(dd.getName()).append("\n");
        }
    }

    private void logInfoBeanCost(StringBuilder stringBuilder, List<DeploymentDescriptor> deploys) {
        long totalTime = 0L;
        long realStart = 0L;
        long realEnd = 0L;
        stringBuilder.append("\n").append("Spring bean load time cost list").append("(").append(deploys.size()).append(") >>>>>>>");
        StringBuilder sb = new StringBuilder();
        Iterator<DeploymentDescriptor> i = deploys.iterator();
        while (i.hasNext()) {
            DeploymentDescriptor dd = i.next();
            String outTreeSymbol = SYMBOLIC1;
            String innerTreeSymbol1 = SYMBOLIC3;
            String innerTreeSymbol2 = SYMBOLIC4;
            if (!i.hasNext()) {
                outTreeSymbol = SYMBOLIC2;
                innerTreeSymbol1 = SYMBOLIC5;
                innerTreeSymbol2 = SYMBOLIC6;
            }
            sb.append(outTreeSymbol).append(dd.getName()).append(" [").append(dd.getElapsedTime()).append(" ms]\n");
            totalTime += dd.getElapsedTime();
            this.beanCostInfo(dd, sb, innerTreeSymbol1, innerTreeSymbol2);
            if (realStart == 0L || dd.getStartTime() < realStart) {
                realStart = dd.getStartTime();
            }
            if (realEnd != 0L && dd.getStartTime() + dd.getElapsedTime() <= realEnd) continue;
            realEnd = dd.getStartTime() + dd.getElapsedTime();
        }
        stringBuilder.append(" [totalTime = ").append(totalTime).append(" ms, realTime = ").append(realEnd - realStart).append(" ms]\n").append((CharSequence)sb);
    }

    private void beanCostInfo(DeploymentDescriptor dd, StringBuilder sb, String innerTreeSymbol1, String innerTreeSymbol2) {
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)dd.getApplicationContext()).getBeanFactory();
        if (!(beanFactory instanceof BeanLoadCostBeanFactory)) {
            return;
        }
        BeanLoadCostBeanFactory beanLoad = (BeanLoadCostBeanFactory)beanFactory;
        List<BeanLoadCostBeanFactory.BeanNode> beanCosts = beanLoad.getBeanLoadList();
        if (!CollectionUtils.isEmpty(beanCosts)) {
            Collections.sort(beanCosts, new Comparator<BeanLoadCostBeanFactory.BeanNode>(){

                @Override
                public int compare(BeanLoadCostBeanFactory.BeanNode o1, BeanLoadCostBeanFactory.BeanNode o2) {
                    return Long.compare(o2.costTime, o1.costTime);
                }
            });
            Iterator<BeanLoadCostBeanFactory.BeanNode> beanNameNode = beanCosts.iterator();
            while (beanNameNode.hasNext()) {
                BeanLoadCostBeanFactory.BeanNode node = beanNameNode.next();
                String innerTreeSymbol = innerTreeSymbol1;
                if (!beanNameNode.hasNext()) {
                    innerTreeSymbol = innerTreeSymbol2;
                }
                sb.append(innerTreeSymbol).append(node).append("\n");
            }
        }
    }

    @Override
    public String getName() {
        return "ModuleLogOutputStage";
    }

    public int getOrder() {
        return 30000;
    }
}

